import { zip } from '@shopify/cli-kit/node/archiver';
import { renderConcurrent } from '@shopify/cli-kit/node/ui';
import { inTemporaryDirectory, mkdirSync, touchFile } from '@shopify/cli-kit/node/fs';
import { joinPath } from '@shopify/cli-kit/node/path';
export async function bundleAndBuildExtensions(options) {
    await inTemporaryDirectory(async (tmpDir) => {
        const bundleDirectory = joinPath(tmpDir, 'bundle');
        await mkdirSync(bundleDirectory);
        await touchFile(joinPath(bundleDirectory, '.shopify'));
        await renderConcurrent({
            processes: options.app.allExtensions.map((extension) => {
                return {
                    prefix: extension.localIdentifier,
                    action: async (stdout, stderr, signal) => {
                        await extension.buildForBundle({ stderr, stdout, signal, app: options.app }, options.identifiers, bundleDirectory);
                    },
                };
            }),
            showTimestamps: false,
        });
        if (options.bundlePath) {
            await zip({
                inputDirectory: bundleDirectory,
                outputZipPath: options.bundlePath,
            });
        }
    });
}
//# sourceMappingURL=bundle.js.map