import buildWeb from './web.js';
import { installAppDependencies } from './dependencies.js';
import { renderConcurrent, renderSuccess } from '@shopify/cli-kit/node/ui';
async function build(options) {
    if (!options.skipDependenciesInstallation && !options.app.usesWorkspaces) {
        await installAppDependencies(options.app);
    }
    const env = {};
    if (options.apiKey) {
        env.SHOPIFY_API_KEY = options.apiKey;
    }
    await renderConcurrent({
        processes: [
            ...options.app.webs.map((web) => {
                return {
                    prefix: ['web', ...web.configuration.roles].join('-'),
                    action: async (stdout, stderr, signal) => {
                        await buildWeb('build', { web, stdout, stderr, signal, env });
                    },
                };
            }),
            ...options.app.allExtensions.map((ext) => {
                return {
                    prefix: ext.localIdentifier,
                    action: async (stdout, stderr, signal) => {
                        await ext.build({ stdout, stderr, signal, app: options.app });
                    },
                };
            }),
        ],
        showTimestamps: false,
    });
    renderSuccess({ headline: [{ userInput: options.app.name }, 'built!'] });
}
export default build;
//# sourceMappingURL=build.js.map