import { zod } from '@shopify/cli-kit/node/schema';
export declare const FlowTriggerExtensionSchema: zod.ZodEffects<zod.ZodObject<{
    name: zod.ZodString;
    metafields: zod.ZodDefault<zod.ZodOptional<zod.ZodArray<zod.ZodObject<{
        namespace: zod.ZodString;
        key: zod.ZodString;
    }, "strip", zod.ZodTypeAny, {
        namespace: string;
        key: string;
    }, {
        namespace: string;
        key: string;
    }>, "many">>>;
    description: zod.ZodOptional<zod.ZodString>;
    handle: zod.ZodEffects<zod.ZodEffects<zod.ZodString, string, string>, string, string>;
    api_version: zod.ZodOptional<zod.ZodString>;
    extension_points: zod.ZodOptional<zod.ZodAny>;
    capabilities: zod.ZodOptional<zod.ZodObject<{
        network_access: zod.ZodOptional<zod.ZodBoolean>;
        block_progress: zod.ZodOptional<zod.ZodBoolean>;
        api_access: zod.ZodOptional<zod.ZodBoolean>;
    }, "strip", zod.ZodTypeAny, {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
    }, {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
    }>>;
    categories: zod.ZodOptional<zod.ZodArray<zod.ZodString, "many">>;
    type: zod.ZodLiteral<"flow_trigger">;
    settings: zod.ZodOptional<zod.ZodObject<{
        fields: zod.ZodOptional<zod.ZodArray<zod.ZodObject<{
            type: zod.ZodString;
            name: zod.ZodOptional<zod.ZodString>;
            description: zod.ZodOptional<zod.ZodString>;
            required: zod.ZodOptional<zod.ZodBoolean>;
            validations: zod.ZodOptional<zod.ZodArray<zod.ZodAny, "many">>;
            key: zod.ZodOptional<zod.ZodString>;
        }, "strip", zod.ZodTypeAny, {
            type: string;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
            key?: string | undefined;
        }, {
            type: string;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
            key?: string | undefined;
        }>, "many">>;
    }, "strip", zod.ZodTypeAny, {
        fields?: {
            type: string;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
            key?: string | undefined;
        }[] | undefined;
    }, {
        fields?: {
            type: string;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
            key?: string | undefined;
        }[] | undefined;
    }>>;
}, "strip", zod.ZodTypeAny, {
    type: "flow_trigger";
    name: string;
    metafields: {
        namespace: string;
        key: string;
    }[];
    handle: string;
    description?: string | undefined;
    api_version?: string | undefined;
    extension_points?: any;
    capabilities?: {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
    } | undefined;
    categories?: string[] | undefined;
    settings?: {
        fields?: {
            type: string;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
            key?: string | undefined;
        }[] | undefined;
    } | undefined;
}, {
    type: "flow_trigger";
    name: string;
    handle: string;
    metafields?: {
        namespace: string;
        key: string;
    }[] | undefined;
    description?: string | undefined;
    api_version?: string | undefined;
    extension_points?: any;
    capabilities?: {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
    } | undefined;
    categories?: string[] | undefined;
    settings?: {
        fields?: {
            type: string;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
            key?: string | undefined;
        }[] | undefined;
    } | undefined;
}>, {
    type: "flow_trigger";
    name: string;
    metafields: {
        namespace: string;
        key: string;
    }[];
    handle: string;
    description?: string | undefined;
    api_version?: string | undefined;
    extension_points?: any;
    capabilities?: {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
    } | undefined;
    categories?: string[] | undefined;
    settings?: {
        fields?: {
            type: string;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
            key?: string | undefined;
        }[] | undefined;
    } | undefined;
}, {
    type: "flow_trigger";
    name: string;
    handle: string;
    metafields?: {
        namespace: string;
        key: string;
    }[] | undefined;
    description?: string | undefined;
    api_version?: string | undefined;
    extension_points?: any;
    capabilities?: {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
    } | undefined;
    categories?: string[] | undefined;
    settings?: {
        fields?: {
            type: string;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
            key?: string | undefined;
        }[] | undefined;
    } | undefined;
}>;
/**
 * Extension specification with all properties and methods needed to load a Flow Trigger.
 */
declare const flowTriggerSpecification: import("../specification.js").ExtensionSpecification<{
    type: "flow_trigger";
    name: string;
    metafields: {
        namespace: string;
        key: string;
    }[];
    handle: string;
    description?: string | undefined;
    api_version?: string | undefined;
    extension_points?: any;
    capabilities?: {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
    } | undefined;
    categories?: string[] | undefined;
    settings?: {
        fields?: {
            type: string;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
            key?: string | undefined;
        }[] | undefined;
    } | undefined;
}>;
export default flowTriggerSpecification;
