import { zod } from '@shopify/cli-kit/node/schema';
export const MetafieldSchema = zod.object({
    namespace: zod.string(),
    key: zod.string(),
});
export const CapabilitiesSchema = zod.object({
    network_access: zod.boolean().optional(),
    block_progress: zod.boolean().optional(),
    api_access: zod.boolean().optional(),
});
export const ExtensionsArraySchema = zod.object({
    type: zod.string().optional(),
    extensions: zod.array(zod.any()).optional(),
});
export const NewExtensionPointSchema = zod.object({
    target: zod.string(),
    module: zod.string(),
    metafields: zod.array(MetafieldSchema).optional(),
});
export const OldExtensionPointsSchema = zod.array(zod.string()).default([]);
export const NewExtensionPointsSchema = zod.array(NewExtensionPointSchema);
export const ExtensionPointSchema = zod.union([OldExtensionPointsSchema, NewExtensionPointsSchema]);
export const ApiVersionSchema = zod.string();
export const FieldSchema = zod.object({
    key: zod.string().optional(),
    name: zod.string().optional(),
    description: zod.string().optional(),
    required: zod.boolean().optional(),
    type: zod.string(),
    validations: zod.array(zod.any()).optional(),
});
export const SettingsSchema = zod.object({
    fields: zod.array(FieldSchema).optional(),
});
export const HandleSchema = zod
    .string()
    .trim()
    .nonempty("Handle can't be empty")
    .max(30, "Handle can't exceed 30 characters")
    .regex(/^[a-zA-Z0-9-]*$/, 'Handle can only contain alphanumeric characters and hyphens')
    .refine((handle) => !handle.startsWith('-') && !handle.endsWith('-'), "Handle can't start or end with a hyphen")
    .refine((handle) => [...handle].some((char) => char !== '-'), "Handle can't be all hyphens");
export const BaseSchema = zod.object({
    name: zod.string(),
    type: zod.string(),
    handle: HandleSchema.optional(),
    description: zod.string().optional(),
    api_version: ApiVersionSchema.optional(),
    extension_points: zod.any().optional(),
    capabilities: CapabilitiesSchema.optional(),
    metafields: zod.array(MetafieldSchema).optional().default([]),
    categories: zod.array(zod.string()).optional(),
    settings: SettingsSchema.optional(),
});
export const BaseSchemaWithHandle = BaseSchema.extend({
    handle: HandleSchema,
});
export const UnifiedSchema = zod.object({
    api_version: ApiVersionSchema.optional(),
    description: zod.string().optional(),
    extensions: zod.array(zod.any()),
    settings: SettingsSchema.optional(),
});
//# sourceMappingURL=schemas.js.map