import { AppErrors } from './loader.js';
import { ExtensionInstance } from '../extensions/extension-instance.js';
import { zod } from '@shopify/cli-kit/node/schema';
import { DotEnvFile } from '@shopify/cli-kit/node/dot-env';
import { PackageManager } from '@shopify/cli-kit/node/node-package-manager';
export declare const LegacyAppSchema: zod.ZodObject<{
    client_id: zod.ZodOptional<zod.ZodNumber>;
    name: zod.ZodOptional<zod.ZodString>;
    scopes: zod.ZodDefault<zod.ZodString>;
    extension_directories: zod.ZodOptional<zod.ZodArray<zod.ZodString, "many">>;
    web_directories: zod.ZodOptional<zod.ZodArray<zod.ZodString, "many">>;
}, "strict", zod.ZodTypeAny, {
    scopes: string;
    client_id?: number | undefined;
    name?: string | undefined;
    extension_directories?: string[] | undefined;
    web_directories?: string[] | undefined;
}, {
    client_id?: number | undefined;
    name?: string | undefined;
    scopes?: string | undefined;
    extension_directories?: string[] | undefined;
    web_directories?: string[] | undefined;
}>;
export declare const AppSchema: zod.ZodObject<{
    name: zod.ZodString;
    client_id: zod.ZodString;
    application_url: zod.ZodEffects<zod.ZodEffects<zod.ZodString, string, string>, string, string>;
    embedded: zod.ZodBoolean;
    access_scopes: zod.ZodOptional<zod.ZodObject<{
        scopes: zod.ZodOptional<zod.ZodString>;
        use_legacy_install_flow: zod.ZodOptional<zod.ZodBoolean>;
    }, "strip", zod.ZodTypeAny, {
        scopes?: string | undefined;
        use_legacy_install_flow?: boolean | undefined;
    }, {
        scopes?: string | undefined;
        use_legacy_install_flow?: boolean | undefined;
    }>>;
    auth: zod.ZodOptional<zod.ZodObject<{
        redirect_urls: zod.ZodArray<zod.ZodEffects<zod.ZodEffects<zod.ZodString, string, string>, string, string>, "many">;
    }, "strip", zod.ZodTypeAny, {
        redirect_urls: string[];
    }, {
        redirect_urls: string[];
    }>>;
    webhooks: zod.ZodObject<{
        api_version: zod.ZodString;
        privacy_compliance: zod.ZodOptional<zod.ZodObject<{
            customer_deletion_url: zod.ZodOptional<zod.ZodEffects<zod.ZodEffects<zod.ZodString, string, string>, string, string>>;
            customer_data_request_url: zod.ZodOptional<zod.ZodEffects<zod.ZodEffects<zod.ZodString, string, string>, string, string>>;
            shop_deletion_url: zod.ZodOptional<zod.ZodEffects<zod.ZodEffects<zod.ZodString, string, string>, string, string>>;
        }, "strip", zod.ZodTypeAny, {
            customer_deletion_url?: string | undefined;
            customer_data_request_url?: string | undefined;
            shop_deletion_url?: string | undefined;
        }, {
            customer_deletion_url?: string | undefined;
            customer_data_request_url?: string | undefined;
            shop_deletion_url?: string | undefined;
        }>>;
    }, "strip", zod.ZodTypeAny, {
        api_version: string;
        privacy_compliance?: {
            customer_deletion_url?: string | undefined;
            customer_data_request_url?: string | undefined;
            shop_deletion_url?: string | undefined;
        } | undefined;
    }, {
        api_version: string;
        privacy_compliance?: {
            customer_deletion_url?: string | undefined;
            customer_data_request_url?: string | undefined;
            shop_deletion_url?: string | undefined;
        } | undefined;
    }>;
    app_proxy: zod.ZodOptional<zod.ZodObject<{
        url: zod.ZodEffects<zod.ZodEffects<zod.ZodString, string, string>, string, string>;
        subpath: zod.ZodString;
        prefix: zod.ZodString;
    }, "strip", zod.ZodTypeAny, {
        url: string;
        subpath: string;
        prefix: string;
    }, {
        url: string;
        subpath: string;
        prefix: string;
    }>>;
    pos: zod.ZodOptional<zod.ZodObject<{
        embedded: zod.ZodBoolean;
    }, "strip", zod.ZodTypeAny, {
        embedded: boolean;
    }, {
        embedded: boolean;
    }>>;
    app_preferences: zod.ZodOptional<zod.ZodObject<{
        url: zod.ZodEffects<zod.ZodEffects<zod.ZodString, string, string>, string, string>;
    }, "strip", zod.ZodTypeAny, {
        url: string;
    }, {
        url: string;
    }>>;
    build: zod.ZodOptional<zod.ZodObject<{
        automatically_update_urls_on_dev: zod.ZodOptional<zod.ZodBoolean>;
        dev_store_url: zod.ZodOptional<zod.ZodString>;
    }, "strip", zod.ZodTypeAny, {
        automatically_update_urls_on_dev?: boolean | undefined;
        dev_store_url?: string | undefined;
    }, {
        automatically_update_urls_on_dev?: boolean | undefined;
        dev_store_url?: string | undefined;
    }>>;
    extension_directories: zod.ZodOptional<zod.ZodArray<zod.ZodString, "many">>;
    web_directories: zod.ZodOptional<zod.ZodArray<zod.ZodString, "many">>;
}, "strict", zod.ZodTypeAny, {
    name: string;
    client_id: string;
    embedded: boolean;
    application_url: string;
    webhooks: {
        api_version: string;
        privacy_compliance?: {
            customer_deletion_url?: string | undefined;
            customer_data_request_url?: string | undefined;
            shop_deletion_url?: string | undefined;
        } | undefined;
    };
    access_scopes?: {
        scopes?: string | undefined;
        use_legacy_install_flow?: boolean | undefined;
    } | undefined;
    auth?: {
        redirect_urls: string[];
    } | undefined;
    app_proxy?: {
        url: string;
        subpath: string;
        prefix: string;
    } | undefined;
    pos?: {
        embedded: boolean;
    } | undefined;
    app_preferences?: {
        url: string;
    } | undefined;
    build?: {
        automatically_update_urls_on_dev?: boolean | undefined;
        dev_store_url?: string | undefined;
    } | undefined;
    extension_directories?: string[] | undefined;
    web_directories?: string[] | undefined;
}, {
    name: string;
    client_id: string;
    embedded: boolean;
    application_url: string;
    webhooks: {
        api_version: string;
        privacy_compliance?: {
            customer_deletion_url?: string | undefined;
            customer_data_request_url?: string | undefined;
            shop_deletion_url?: string | undefined;
        } | undefined;
    };
    access_scopes?: {
        scopes?: string | undefined;
        use_legacy_install_flow?: boolean | undefined;
    } | undefined;
    auth?: {
        redirect_urls: string[];
    } | undefined;
    app_proxy?: {
        url: string;
        subpath: string;
        prefix: string;
    } | undefined;
    pos?: {
        embedded: boolean;
    } | undefined;
    app_preferences?: {
        url: string;
    } | undefined;
    build?: {
        automatically_update_urls_on_dev?: boolean | undefined;
        dev_store_url?: string | undefined;
    } | undefined;
    extension_directories?: string[] | undefined;
    web_directories?: string[] | undefined;
}>;
export declare const AppConfigurationSchema: zod.ZodUnion<[zod.ZodObject<{
    client_id: zod.ZodOptional<zod.ZodNumber>;
    name: zod.ZodOptional<zod.ZodString>;
    scopes: zod.ZodDefault<zod.ZodString>;
    extension_directories: zod.ZodOptional<zod.ZodArray<zod.ZodString, "many">>;
    web_directories: zod.ZodOptional<zod.ZodArray<zod.ZodString, "many">>;
}, "strict", zod.ZodTypeAny, {
    scopes: string;
    client_id?: number | undefined;
    name?: string | undefined;
    extension_directories?: string[] | undefined;
    web_directories?: string[] | undefined;
}, {
    client_id?: number | undefined;
    name?: string | undefined;
    scopes?: string | undefined;
    extension_directories?: string[] | undefined;
    web_directories?: string[] | undefined;
}>, zod.ZodObject<{
    name: zod.ZodString;
    client_id: zod.ZodString;
    application_url: zod.ZodEffects<zod.ZodEffects<zod.ZodString, string, string>, string, string>;
    embedded: zod.ZodBoolean;
    access_scopes: zod.ZodOptional<zod.ZodObject<{
        scopes: zod.ZodOptional<zod.ZodString>;
        use_legacy_install_flow: zod.ZodOptional<zod.ZodBoolean>;
    }, "strip", zod.ZodTypeAny, {
        scopes?: string | undefined;
        use_legacy_install_flow?: boolean | undefined;
    }, {
        scopes?: string | undefined;
        use_legacy_install_flow?: boolean | undefined;
    }>>;
    auth: zod.ZodOptional<zod.ZodObject<{
        redirect_urls: zod.ZodArray<zod.ZodEffects<zod.ZodEffects<zod.ZodString, string, string>, string, string>, "many">;
    }, "strip", zod.ZodTypeAny, {
        redirect_urls: string[];
    }, {
        redirect_urls: string[];
    }>>;
    webhooks: zod.ZodObject<{
        api_version: zod.ZodString;
        privacy_compliance: zod.ZodOptional<zod.ZodObject<{
            customer_deletion_url: zod.ZodOptional<zod.ZodEffects<zod.ZodEffects<zod.ZodString, string, string>, string, string>>;
            customer_data_request_url: zod.ZodOptional<zod.ZodEffects<zod.ZodEffects<zod.ZodString, string, string>, string, string>>;
            shop_deletion_url: zod.ZodOptional<zod.ZodEffects<zod.ZodEffects<zod.ZodString, string, string>, string, string>>;
        }, "strip", zod.ZodTypeAny, {
            customer_deletion_url?: string | undefined;
            customer_data_request_url?: string | undefined;
            shop_deletion_url?: string | undefined;
        }, {
            customer_deletion_url?: string | undefined;
            customer_data_request_url?: string | undefined;
            shop_deletion_url?: string | undefined;
        }>>;
    }, "strip", zod.ZodTypeAny, {
        api_version: string;
        privacy_compliance?: {
            customer_deletion_url?: string | undefined;
            customer_data_request_url?: string | undefined;
            shop_deletion_url?: string | undefined;
        } | undefined;
    }, {
        api_version: string;
        privacy_compliance?: {
            customer_deletion_url?: string | undefined;
            customer_data_request_url?: string | undefined;
            shop_deletion_url?: string | undefined;
        } | undefined;
    }>;
    app_proxy: zod.ZodOptional<zod.ZodObject<{
        url: zod.ZodEffects<zod.ZodEffects<zod.ZodString, string, string>, string, string>;
        subpath: zod.ZodString;
        prefix: zod.ZodString;
    }, "strip", zod.ZodTypeAny, {
        url: string;
        subpath: string;
        prefix: string;
    }, {
        url: string;
        subpath: string;
        prefix: string;
    }>>;
    pos: zod.ZodOptional<zod.ZodObject<{
        embedded: zod.ZodBoolean;
    }, "strip", zod.ZodTypeAny, {
        embedded: boolean;
    }, {
        embedded: boolean;
    }>>;
    app_preferences: zod.ZodOptional<zod.ZodObject<{
        url: zod.ZodEffects<zod.ZodEffects<zod.ZodString, string, string>, string, string>;
    }, "strip", zod.ZodTypeAny, {
        url: string;
    }, {
        url: string;
    }>>;
    build: zod.ZodOptional<zod.ZodObject<{
        automatically_update_urls_on_dev: zod.ZodOptional<zod.ZodBoolean>;
        dev_store_url: zod.ZodOptional<zod.ZodString>;
    }, "strip", zod.ZodTypeAny, {
        automatically_update_urls_on_dev?: boolean | undefined;
        dev_store_url?: string | undefined;
    }, {
        automatically_update_urls_on_dev?: boolean | undefined;
        dev_store_url?: string | undefined;
    }>>;
    extension_directories: zod.ZodOptional<zod.ZodArray<zod.ZodString, "many">>;
    web_directories: zod.ZodOptional<zod.ZodArray<zod.ZodString, "many">>;
}, "strict", zod.ZodTypeAny, {
    name: string;
    client_id: string;
    embedded: boolean;
    application_url: string;
    webhooks: {
        api_version: string;
        privacy_compliance?: {
            customer_deletion_url?: string | undefined;
            customer_data_request_url?: string | undefined;
            shop_deletion_url?: string | undefined;
        } | undefined;
    };
    access_scopes?: {
        scopes?: string | undefined;
        use_legacy_install_flow?: boolean | undefined;
    } | undefined;
    auth?: {
        redirect_urls: string[];
    } | undefined;
    app_proxy?: {
        url: string;
        subpath: string;
        prefix: string;
    } | undefined;
    pos?: {
        embedded: boolean;
    } | undefined;
    app_preferences?: {
        url: string;
    } | undefined;
    build?: {
        automatically_update_urls_on_dev?: boolean | undefined;
        dev_store_url?: string | undefined;
    } | undefined;
    extension_directories?: string[] | undefined;
    web_directories?: string[] | undefined;
}, {
    name: string;
    client_id: string;
    embedded: boolean;
    application_url: string;
    webhooks: {
        api_version: string;
        privacy_compliance?: {
            customer_deletion_url?: string | undefined;
            customer_data_request_url?: string | undefined;
            shop_deletion_url?: string | undefined;
        } | undefined;
    };
    access_scopes?: {
        scopes?: string | undefined;
        use_legacy_install_flow?: boolean | undefined;
    } | undefined;
    auth?: {
        redirect_urls: string[];
    } | undefined;
    app_proxy?: {
        url: string;
        subpath: string;
        prefix: string;
    } | undefined;
    pos?: {
        embedded: boolean;
    } | undefined;
    app_preferences?: {
        url: string;
    } | undefined;
    build?: {
        automatically_update_urls_on_dev?: boolean | undefined;
        dev_store_url?: string | undefined;
    } | undefined;
    extension_directories?: string[] | undefined;
    web_directories?: string[] | undefined;
}>]>;
/**
 * Check whether a shopify.app.toml schema is valid against the legacy schema definition.
 * @param item - the item to validate
 */
export declare function isLegacyAppSchema(item: AppConfiguration): item is LegacyAppConfiguration;
/**
 * Check whether a shopify.app.toml schema is valid against the current schema definition.
 * @param item - the item to validate
 */
export declare function isCurrentAppSchema(item: AppConfiguration): item is CurrentAppConfiguration;
/**
 * Get scopes from a given app.toml config file.
 * @param config - a configuration file
 */
export declare function getAppScopes(config: AppConfiguration): string;
/**
 * Get scopes as an array from a given app.toml config file.
 * @param config - a configuration file
 */
export declare function getAppScopesArray(config: AppConfiguration): string[];
export declare function usesLegacyScopesBehavior(app: AppInterface | AppConfiguration): boolean;
export declare function appIsLaunchable(app: AppInterface): boolean;
export declare enum WebType {
    Frontend = "frontend",
    Backend = "backend",
    Background = "background"
}
export declare const WebConfigurationSchema: zod.ZodUnion<[zod.ZodObject<{
    name: zod.ZodOptional<zod.ZodString>;
    auth_callback_path: zod.ZodOptional<zod.ZodUnion<[zod.ZodEffects<zod.ZodString, string, unknown>, zod.ZodArray<zod.ZodEffects<zod.ZodString, string, unknown>, "many">]>>;
    webhooks_path: zod.ZodOptional<zod.ZodEffects<zod.ZodString, string, unknown>>;
    port: zod.ZodOptional<zod.ZodNumber>;
    commands: zod.ZodObject<{
        build: zod.ZodOptional<zod.ZodString>;
        dev: zod.ZodString;
    }, "strip", zod.ZodTypeAny, {
        dev: string;
        build?: string | undefined;
    }, {
        dev: string;
        build?: string | undefined;
    }>;
    hmr_server: zod.ZodOptional<zod.ZodObject<{
        http_paths: zod.ZodArray<zod.ZodString, "many">;
    }, "strip", zod.ZodTypeAny, {
        http_paths: string[];
    }, {
        http_paths: string[];
    }>>;
    roles: zod.ZodArray<zod.ZodDefault<zod.ZodEnum<[WebType.Frontend, WebType.Backend, WebType.Background]>>, "many">;
}, "strip", zod.ZodTypeAny, {
    commands: {
        dev: string;
        build?: string | undefined;
    };
    roles: WebType[];
    name?: string | undefined;
    auth_callback_path?: string | string[] | undefined;
    webhooks_path?: string | undefined;
    port?: number | undefined;
    hmr_server?: {
        http_paths: string[];
    } | undefined;
}, {
    commands: {
        dev: string;
        build?: string | undefined;
    };
    roles: (WebType | undefined)[];
    name?: string | undefined;
    auth_callback_path?: unknown;
    webhooks_path?: unknown;
    port?: number | undefined;
    hmr_server?: {
        http_paths: string[];
    } | undefined;
}>, zod.ZodObject<{
    name: zod.ZodOptional<zod.ZodString>;
    auth_callback_path: zod.ZodOptional<zod.ZodUnion<[zod.ZodEffects<zod.ZodString, string, unknown>, zod.ZodArray<zod.ZodEffects<zod.ZodString, string, unknown>, "many">]>>;
    webhooks_path: zod.ZodOptional<zod.ZodEffects<zod.ZodString, string, unknown>>;
    port: zod.ZodOptional<zod.ZodNumber>;
    commands: zod.ZodObject<{
        build: zod.ZodOptional<zod.ZodString>;
        dev: zod.ZodString;
    }, "strip", zod.ZodTypeAny, {
        dev: string;
        build?: string | undefined;
    }, {
        dev: string;
        build?: string | undefined;
    }>;
    hmr_server: zod.ZodOptional<zod.ZodObject<{
        http_paths: zod.ZodArray<zod.ZodString, "many">;
    }, "strip", zod.ZodTypeAny, {
        http_paths: string[];
    }, {
        http_paths: string[];
    }>>;
    type: zod.ZodDefault<zod.ZodEnum<[WebType.Frontend, WebType.Backend, WebType.Background]>>;
}, "strip", zod.ZodTypeAny, {
    type: WebType;
    commands: {
        dev: string;
        build?: string | undefined;
    };
    name?: string | undefined;
    auth_callback_path?: string | string[] | undefined;
    webhooks_path?: string | undefined;
    port?: number | undefined;
    hmr_server?: {
        http_paths: string[];
    } | undefined;
}, {
    commands: {
        dev: string;
        build?: string | undefined;
    };
    name?: string | undefined;
    auth_callback_path?: unknown;
    webhooks_path?: unknown;
    port?: number | undefined;
    hmr_server?: {
        http_paths: string[];
    } | undefined;
    type?: WebType | undefined;
}>]>;
export declare const ProcessedWebConfigurationSchema: zod.ZodObject<{
    name: zod.ZodOptional<zod.ZodString>;
    auth_callback_path: zod.ZodOptional<zod.ZodUnion<[zod.ZodEffects<zod.ZodString, string, unknown>, zod.ZodArray<zod.ZodEffects<zod.ZodString, string, unknown>, "many">]>>;
    webhooks_path: zod.ZodOptional<zod.ZodEffects<zod.ZodString, string, unknown>>;
    port: zod.ZodOptional<zod.ZodNumber>;
    commands: zod.ZodObject<{
        build: zod.ZodOptional<zod.ZodString>;
        dev: zod.ZodString;
    }, "strip", zod.ZodTypeAny, {
        dev: string;
        build?: string | undefined;
    }, {
        dev: string;
        build?: string | undefined;
    }>;
    hmr_server: zod.ZodOptional<zod.ZodObject<{
        http_paths: zod.ZodArray<zod.ZodString, "many">;
    }, "strip", zod.ZodTypeAny, {
        http_paths: string[];
    }, {
        http_paths: string[];
    }>>;
    roles: zod.ZodArray<zod.ZodDefault<zod.ZodEnum<[WebType.Frontend, WebType.Backend, WebType.Background]>>, "many">;
}, "strip", zod.ZodTypeAny, {
    commands: {
        dev: string;
        build?: string | undefined;
    };
    roles: WebType[];
    name?: string | undefined;
    auth_callback_path?: string | string[] | undefined;
    webhooks_path?: string | undefined;
    port?: number | undefined;
    hmr_server?: {
        http_paths: string[];
    } | undefined;
}, {
    commands: {
        dev: string;
        build?: string | undefined;
    };
    roles: (WebType | undefined)[];
    name?: string | undefined;
    auth_callback_path?: unknown;
    webhooks_path?: unknown;
    port?: number | undefined;
    hmr_server?: {
        http_paths: string[];
    } | undefined;
}>;
export type AppConfiguration = zod.infer<typeof AppConfigurationSchema>;
export type CurrentAppConfiguration = zod.infer<typeof AppSchema>;
export type LegacyAppConfiguration = zod.infer<typeof LegacyAppSchema>;
export type WebConfiguration = zod.infer<typeof WebConfigurationSchema>;
export type ProcessedWebConfiguration = zod.infer<typeof ProcessedWebConfigurationSchema>;
export type WebConfigurationCommands = keyof WebConfiguration['commands'];
export interface Web {
    directory: string;
    configuration: ProcessedWebConfiguration;
    framework?: string;
}
export interface AppConfigurationInterface {
    directory: string;
    configuration: AppConfiguration;
    configurationPath: string;
}
export interface AppInterface extends AppConfigurationInterface {
    name: string;
    idEnvironmentVariableName: string;
    packageManager: PackageManager;
    nodeDependencies: {
        [key: string]: string;
    };
    webs: Web[];
    usesWorkspaces: boolean;
    dotenv?: DotEnvFile;
    allExtensions: ExtensionInstance[];
    errors?: AppErrors;
    hasExtensions: () => boolean;
    updateDependencies: () => Promise<void>;
    extensionsForType: (spec: {
        identifier: string;
        externalIdentifier: string;
    }) => ExtensionInstance[];
}
export declare class App implements AppInterface {
    name: string;
    idEnvironmentVariableName: string;
    directory: string;
    packageManager: PackageManager;
    configuration: AppConfiguration;
    configurationPath: string;
    nodeDependencies: {
        [key: string]: string;
    };
    webs: Web[];
    usesWorkspaces: boolean;
    dotenv?: DotEnvFile;
    errors?: AppErrors;
    allExtensions: ExtensionInstance[];
    constructor(name: string, idEnvironmentVariableName: string, directory: string, packageManager: PackageManager, configuration: AppConfiguration, configurationPath: string, nodeDependencies: {
        [key: string]: string;
    }, webs: Web[], extensions: ExtensionInstance[], usesWorkspaces: boolean, dotenv?: DotEnvFile, errors?: AppErrors);
    updateDependencies(): Promise<void>;
    hasExtensions(): boolean;
    extensionsForType(specification: {
        identifier: string;
        externalIdentifier: string;
    }): ExtensionInstance[];
}
export declare class EmptyApp extends App {
    constructor();
}
type RendererVersionResult = {
    name: string;
    version: string;
} | undefined | 'not_found';
/**
 * Given a UI extension and the app it belongs to, it returns the version of the renderer package.
 * Looks for `/node_modules/@shopify/{renderer-package-name}/package.json` to find the real version used.
 * @param uiExtensionType - UI extension whose renderer version will be obtained.
 * @param app - App object containing the extension.
 * @returns The version if the dependency exists.
 */
export declare function getUIExtensionRendererVersion(extension: ExtensionInstance): Promise<RendererVersionResult>;
export declare function getDependencyVersion(dependency: string, directory: string): Promise<RendererVersionResult>;
export {};
