import { appFlags } from '../../flags.js';
import { loadApp } from '../../models/app/loader.js';
import Command from '../../utilities/app-command.js';
import { loadLocalExtensionsSpecifications } from '../../models/extensions/load-specifications.js';
import { release } from '../../services/release.js';
import { showApiKeyDeprecationWarning } from '../../prompts/deprecation-warnings.js';
import { Flags } from '@oclif/core';
import { globalFlags } from '@shopify/cli-kit/node/cli';
import { addPublicMetadata } from '@shopify/cli-kit/node/metadata';
class Release extends Command {
    async run() {
        const { flags } = await this.parse(Release);
        if (flags['api-key']) {
            await showApiKeyDeprecationWarning();
        }
        const apiKey = flags['client-id'] || flags['api-key'];
        await addPublicMetadata(() => ({
            cmd_app_reset_used: flags.reset,
        }));
        const specifications = await loadLocalExtensionsSpecifications(this.config);
        const app = await loadApp({ specifications, directory: flags.path, configName: flags.config });
        await release({
            app,
            apiKey,
            reset: flags.reset,
            force: flags.force,
            version: flags.version,
            commandConfig: this.config,
        });
    }
}
Release.description = 'Release an app version.';
Release.flags = {
    ...globalFlags,
    ...appFlags,
    'api-key': Flags.string({
        hidden: true,
        description: 'The API key of your app.',
        env: 'SHOPIFY_FLAG_APP_API_KEY',
        exclusive: ['config'],
    }),
    'client-id': Flags.string({
        hidden: false,
        description: 'The Client ID of your app.',
        env: 'SHOPIFY_FLAG_CLIENT_ID',
        exclusive: ['config'],
    }),
    reset: Flags.boolean({
        hidden: false,
        description: 'Reset all your settings.',
        env: 'SHOPIFY_FLAG_RESET',
        default: false,
    }),
    version: Flags.string({
        hidden: false,
        description: 'The name of the app version to release.',
        env: 'SHOPIFY_FLAG_VERSION',
        required: true,
    }),
};
export default Release;
//# sourceMappingURL=release.js.map