export declare const PushConfig: string;
interface GdprWebhooks {
    customerDeletionUrl?: string;
    customerDataRequestUrl?: string;
    shopDeletionUrl?: string;
}
interface AppProxy {
    proxyUrl: string;
    proxySubPath: string;
    proxySubPathPrefix: string;
}
export interface PushConfigVariables {
    title: string;
    apiKey: string;
    applicationUrl?: string;
    redirectUrlAllowlist?: string[] | null;
    requestedAccessScopes?: string[];
    webhookApiVersion?: string;
    gdprWebhooks?: GdprWebhooks;
    appProxy?: AppProxy;
    posEmbedded?: boolean;
    embedded?: boolean;
    preferencesUrl?: string | null;
}
export interface PushConfigSchema {
    appUpdate: {
        userErrors: {
            field: string[];
            message: string;
        }[];
    };
}
export {};
