import { gql } from 'graphql-request';
export const GetConfig = gql `
  query GetConfig($apiKey: String!) {
    app(apiKey: $apiKey) {
      id
      title
      apiKey
      organizationId
      appType
      grantedScopes
      applicationUrl
      redirectUrlWhitelist
      preferencesUrl
      webhookApiVersion
      embedded
      posEmbedded
      requestedAccessScopes
      gdprWebhooks {
        customerDeletionUrl
        customerDataRequestUrl
        shopDeletionUrl
      }
      appProxy {
        subPath
        subPathPrefix
        url
      }
    }
  }
`;
//# sourceMappingURL=get_config.js.map