export declare const CreateAppQuery: string;
export interface CreateAppQueryVariables {
    org: number;
    title: string;
    appUrl: string;
    redir: string[];
    type: string;
    requestedAccessScopes?: string[];
}
export interface CreateAppQuerySchema {
    appCreate: {
        app: {
            id: string;
            title: string;
            apiKey: string;
            organizationId: string;
            apiSecretKeys: {
                secret: string;
            }[];
            appType: string;
            grantedScopes: string[];
            betas?: {
                unifiedAppDeployment?: boolean;
                unifiedAppDeploymentOptIn?: boolean;
            };
            applicationUrl: string;
            redirectUrlWhitelist: string[];
            requestedAccessScopes?: string[];
            webhookApiVersion: string;
            embedded: boolean;
            posEmbedded?: boolean;
            preferencesUrl?: string;
            gdprWebhooks?: {
                customerDeletionUrl?: string;
                customerDataRequestUrl?: string;
                shopDeletionUrl?: string;
            };
            appProxy?: {
                subPath: string;
                subPathPrefix: string;
                url: string;
            };
        };
        userErrors: {
            field: string[];
            message: string;
        }[];
    };
}
