import type { AppConfigV2, AppMiddleware, ClientApplication, ClientApplicationCreator, ClientApplicationTransportInjector } from './types';
export declare const WINDOW_UNDEFINED_MESSAGE = "window is not defined. Running an app outside a browser is not supported";
/**
 * @internal
 */
export declare const createClientApp: ClientApplicationTransportInjector;
/**
 * @public
 */
export declare function createAppWrapper(frame: Window, localOrigin?: string, middleware?: AppMiddleware[]): ClientApplicationCreator;
/**
 * Creates your application instance.
 * @param config - `apiKey` and `host` are both required.
 * @remarks
 * You will need to store `host` during the authentication process and then retrieve it for the code to work properly. To learn more about this process, see {@link https://help.shopify.com/api/embedded-apps/shop-origin | Getting and storing the shop origin}.
 * @public
 */
export declare function createApp(config: AppConfigV2): ClientApplication;
/**
 * {@inheritdocs createApp}
 * @public
 */
export default createApp;
