import { LocationOrHref } from '../RoutePropagator';
export interface NavigationLink {
    label: string;
    destination: string;
}
export interface Props {
    /**
     * List of links in navigation menu
     */
    navigationLinks: NavigationLink[];
    /**
     * Custom matcher to set active link.
     * This function will be called with each link and the current location.
     * If it returns true the current link will be set to the active link.
     */
    matcher?: (link: NavigationLink, location: LocationOrHref) => boolean;
}
export default function NavigationMenu({ navigationLinks, matcher }: Props): null;
