import { Action as AppBridgeRedirectAction } from '../Navigation/Redirect';
import { ClientApplication } from '../../client';
import { ActionSetWithChildren } from '../ActionSet';
import { Button, Payload as ButtonPayload } from '../Button';
import { ButtonGroup, Payload as ButtonGroupPayload } from '../ButtonGroup';
import { ActionSetProps, ClickAction, Group, MetaAction } from '../types';
export declare enum Action {
    UPDATE = "APP::TITLEBAR::UPDATE",
    BUTTON_CLICK = "APP::TITLEBAR::BUTTONS::BUTTON::CLICK",
    BUTTON_UPDATE = "APP::TITLEBAR::BUTTONS::BUTTON::UPDATE",
    BUTTON_GROUP_UPDATE = "APP::TITLEBAR::BUTTONS::BUTTONGROUP::UPDATE",
    BREADCRUMBS_CLICK = "APP::TITLEBAR::BREADCRUMBS::BUTTON::CLICK",
    BREADCRUMBS_UPDATE = "APP::TITLEBAR::BREADCRUMBS::BUTTON::UPDATE"
}
export interface Breadcrumb {
    content: string;
    url: string;
}
export interface ButtonsOptions {
    primary?: Button;
    secondary?: (ButtonGroup | Button)[];
}
export interface Options {
    title?: string;
    buttons?: ButtonsOptions;
    breadcrumbs?: Button;
}
export interface ButtonsPayload {
    primary?: ButtonPayload;
    secondary?: (ButtonPayload | ButtonGroupPayload)[];
}
export interface Payload {
    readonly id?: string;
    title?: string;
    buttons?: ButtonsPayload;
    breadcrumbs?: ButtonPayload;
}
export interface UpdateAction extends MetaAction {
    readonly group: typeof Group.TitleBar;
    payload: Payload;
}
export declare type TitleBarAction = UpdateAction | ClickAction | MetaAction;
export declare function clickActionButton(id: string, payload?: any): ClickAction;
export declare function clickBreadcrumb(id: string, payload?: any): ClickAction;
export declare function update(payload: Payload): UpdateAction;
export declare type Target = Exclude<keyof typeof AppBridgeRedirectAction, 'ADMIN_SECTION'>;
export interface ActionProps {
    /** Content the action displays */
    content?: string;
    /** Should the action be styled as destructive */
    destructive?: boolean;
    /** Should the action be disabled */
    disabled?: boolean;
    /** Should the action be loading */
    loading?: boolean;
    /** Forces url to open in a new tab */
    external?: boolean;
    /** Use Polaris plain styling */
    plain?: boolean;
    /**
     * Where to display the target link
     * @default 'APP'
     */
    target?: Target;
    /** A destination to link to */
    url?: string;
    id: string;
    /** Callback when an action takes place */
    onAction?(): void;
}
export declare type DeepPartial<T> = T extends object ? {
    [P in keyof T]?: DeepPartial<T[P]>;
} : T;
export interface UpdatePayload {
    readonly id?: string;
    title?: string;
    buttons?: ButtonsPayload;
    breadcrumb?: ButtonPayload;
}
export interface TitleBarApi {
    update: (payload: DeepPartial<Payload>) => void;
}
export declare class TitleBar extends ActionSetWithChildren implements ActionSetProps<Options, Payload> {
    title?: string;
    primary?: ButtonPayload;
    secondary?: (ButtonPayload | ButtonGroupPayload)[];
    primaryOptions?: Button;
    secondaryOptions?: (ButtonGroup | Button)[];
    breadcrumb?: ButtonPayload;
    breadcrumbsOption?: Button;
    constructor(app: ClientApplication, options: Options);
    get buttons(): ButtonsPayload | undefined;
    get buttonsOptions(): ButtonsOptions | undefined;
    get options(): Options;
    get payload(): Payload;
    set(options: Partial<Options>, shouldUpdate?: boolean): this;
    dispatch(action: Action): this;
    protected getButton(button: Button | ButtonGroup, subgroups: string[], updateCb: (newPayload: ButtonPayload | ButtonGroupPayload) => void): ButtonPayload | ButtonGroupPayload;
    protected updatePrimaryButton(newPayload: ButtonPayload): void;
    protected updateSecondaryButtons(newPayload: ButtonPayload | ButtonGroupPayload): void;
    protected updateBreadcrumbButton(newPayload: ButtonPayload): void;
    protected setPrimaryButton(newOptions?: Button): void;
    protected setSecondaryButton(newOptions?: (ButtonGroup | Button)[]): void;
    protected setBreadcrumbs(breadcrumb?: Button): void;
    protected getChildButton(newAction: undefined | Button, currentAction: undefined | Button): Button | undefined;
}
