import { ClientApplication } from '../../client/types';
import { ActionSet } from '../ActionSet';
import { ActionSetProps, Group, MetaAction } from '../types';
export declare enum Action {
    OPEN = "APP::RESOURCE_PICKER::OPEN",
    SELECT = "APP::RESOURCE_PICKER::SELECT",
    CLOSE = "APP::RESOURCE_PICKER::CLOSE",
    UPDATE = "APP::RESOURCE_PICKER::UPDATE",
    CANCEL = "APP::RESOURCE_PICKER::CANCEL"
}
export declare type Money = string;
export declare enum CollectionSortOrder {
    Manual = "MANUAL",
    BestSelling = "BEST_SELLING",
    AlphaAsc = "ALPHA_ASC",
    AlphaDesc = "ALPHA_DESC",
    PriceDesc = "PRICE_DESC",
    PriceAsc = "PRICE_ASC",
    CreatedDesc = "CREATED_DESC",
    Created = "CREATED",
    MostRelevant = "MOST_RELEVANT"
}
export declare enum FulfillmentServiceType {
    GiftCard = "GIFT_CARD",
    Manual = "MANUAL",
    ThirdParty = "THIRD_PARTY"
}
export declare enum WeightUnit {
    Kilograms = "KILOGRAMS",
    Grams = "GRAMS",
    Pounds = "POUNDS",
    Ounces = "OUNCES"
}
export declare enum ProductVariantInventoryPolicy {
    Deny = "DENY",
    Continue = "CONTINUE"
}
export declare enum ProductVariantInventoryManagement {
    Shopify = "SHOPIFY",
    NotManaged = "NOT_MANAGED",
    FulfillmentService = "FULFILLMENT_SERVICE"
}
export declare enum ProductStatus {
    Active = "ACTIVE",
    Archived = "ARCHIVED",
    Draft = "DRAFT"
}
export interface Image {
    id: string;
    altText?: string;
    originalSrc: string;
}
/**
 * @internal
 */
export interface Resource {
    /** in GraphQL id format, ie 'gid://shopify/Product/1' */
    id: string;
}
/**
 * @public
 */
export interface BaseResource extends Resource {
    variants?: Resource[];
}
export interface CollectionRule {
    column: string;
    condition: string;
    relation: string;
}
export interface RuleSet {
    appliedDisjunctively: boolean;
    rules: CollectionRule[];
}
export interface Collection extends Resource {
    availablePublicationCount: number;
    description: string;
    descriptionHtml: string;
    handle: string;
    id: string;
    image?: Image | null;
    productsAutomaticallySortedCount: number;
    productsCount: number;
    productsManuallySortedCount: number;
    publicationCount: number;
    ruleSet?: RuleSet | null;
    seo: {
        description?: string | null;
        title?: string | null;
    };
    sortOrder: CollectionSortOrder;
    storefrontId: string;
    templateSuffix?: string | null;
    title: string;
    updatedAt: string;
}
export interface ProductVariant extends Resource {
    availableForSale: boolean;
    barcode?: string | null;
    compareAtPrice?: Money | null;
    createdAt: string;
    displayName: string;
    fulfillmentService?: {
        id: string;
        inventoryManagement: boolean;
        productBased: boolean;
        serviceName: string;
        type: FulfillmentServiceType;
    };
    image?: Image | null;
    inventoryItem: {
        id: string;
    };
    inventoryManagement: ProductVariantInventoryManagement;
    inventoryPolicy: ProductVariantInventoryPolicy;
    inventoryQuantity?: number | null;
    position: number;
    price: Money;
    product: Partial<Product>;
    requiresShipping: boolean;
    selectedOptions: {
        value?: string | null;
    }[];
    sku?: string | null;
    taxable: boolean;
    title: string;
    weight?: number | null;
    weightUnit: WeightUnit;
    updatedAt: string;
}
export interface Product extends Resource {
    availablePublicationCount: number;
    createdAt: string;
    descriptionHtml: string;
    handle: string;
    hasOnlyDefaultVariant: boolean;
    images: Image[];
    options: {
        id: string;
        name: string;
        position: number;
        values: string[];
    }[];
    productType: string;
    publishedAt?: string | null;
    tags: string[];
    templateSuffix?: string | null;
    title: string;
    totalInventory: number;
    tracksInventory: boolean;
    variants: Partial<ProductVariant>[];
    vendor: string;
    updatedAt: string;
    status: ProductStatus;
}
export interface CancelPayload {
    readonly id?: string;
}
export declare type ClosePayload = CancelPayload;
export interface Payload {
    readonly id?: string;
    initialQuery?: string;
    initialSelectionIds?: BaseResource[];
    selectMultiple?: boolean | number;
    showHidden?: boolean;
    showVariants?: boolean;
    showDraft?: boolean;
    showArchived?: boolean;
    showDraftBadge?: boolean;
    showArchivedBadge?: boolean;
    actionVerb?: ActionVerb;
    resourceType: ResourceType;
}
export declare type ResourceSelection = Product | ProductVariant | Collection;
export interface SelectPayload {
    readonly id?: string;
    selection: ResourceSelection[];
}
export interface Options {
    initialQuery?: string;
    initialSelectionIds?: BaseResource[];
    showHidden?: boolean;
    selectMultiple?: boolean | number;
    actionVerb?: ActionVerb;
}
export interface ProductOptions extends Options {
    showVariants?: boolean;
    showDraft?: boolean;
    showArchived?: boolean;
    showDraftBadge?: boolean;
    showArchivedBadge?: boolean;
}
export interface BaseOptions {
    resourceType: ResourceType;
    options?: Options | ProductOptions;
}
export declare enum ResourceType {
    Product = "product",
    ProductVariant = "variant",
    Collection = "collection"
}
export declare enum ActionVerb {
    Add = "add",
    Select = "select"
}
export interface ActionBase extends MetaAction {
    readonly group: typeof Group.ResourcePicker;
}
export interface SelectAction extends ActionBase {
    readonly type: typeof Action.SELECT;
    readonly payload: SelectPayload;
}
export interface UpdateAction extends ActionBase {
    readonly type: typeof Action.UPDATE;
    readonly payload: Payload;
}
export interface CancelAction extends ActionBase {
    readonly type: typeof Action.CANCEL;
}
export declare type CloseAction = CancelAction;
export interface OpenAction extends ActionBase {
    readonly type: typeof Action.OPEN;
    readonly payload: Payload;
}
export declare type ResourcePickerAction = SelectAction | UpdateAction | CancelAction | OpenAction | MetaAction;
export declare function select(payload: SelectPayload): SelectAction;
export declare function open(payload: Payload): OpenAction;
export declare function cancel(payload: CancelPayload): CancelAction;
export declare function close(payload: ClosePayload): CloseAction;
export declare function update(payload: Payload): UpdateAction;
export declare class ResourcePicker extends ActionSet implements ActionSetProps<Options | ProductOptions, Payload> {
    readonly resourceType: ResourceType;
    initialQuery?: string;
    selectMultiple?: boolean | number;
    initialSelectionIds: BaseResource[];
    selection: ResourceSelection[];
    showHidden?: boolean;
    showVariants?: boolean;
    showDraft?: boolean;
    showArchived?: boolean;
    showDraftBadge?: boolean;
    showArchivedBadge?: boolean;
    actionVerb?: ActionVerb;
    constructor(app: ClientApplication, options: Options | ProductOptions, resourceType: ResourceType);
    get payload(): {
        id: string;
        resourceType: ResourceType;
        initialQuery?: string | undefined;
        initialSelectionIds?: BaseResource[] | undefined;
        showHidden?: boolean | undefined;
        selectMultiple?: number | boolean | undefined;
        actionVerb?: ActionVerb | undefined;
    };
    get options(): Options;
    set(options: Partial<Options | ProductOptions>, shouldUpdate?: boolean): this;
    dispatch(action: Action, selection?: ResourceSelection[]): this;
    protected update(): void;
    protected open(): void;
    protected cancel(): void;
    protected close(): void;
}
