import { ClientApplication } from '../../client/types';
import { ActionSet } from '../ActionSet';
import { Group, MetaAction, ActionSetProps } from '../types';
/**
 * Action for the Leave Confirmation group
 * @public
 */
export declare enum Action {
    ENABLE = "APP::LEAVE_CONFIRMATION::ENABLE",
    DISABLE = "APP::LEAVE_CONFIRMATION::DISABLE",
    CONFIRM = "APP::LEAVE_CONFIRMATION::CONFIRM"
}
/**
 * Payload for the Leave Confirmation group
 * @public
 */
export interface Options {
    title?: string;
    description?: string;
}
export interface Payload extends Options {
    readonly id?: string;
}
/**
 * Leave Confirmation action interface
 * @internal
 */
export interface ActionBase extends MetaAction {
    readonly group: typeof Group.LeaveConfirmation;
}
export interface EnableAction extends ActionBase {
    readonly type: typeof Action.ENABLE;
    readonly payload: Payload;
}
export interface DisableAction extends ActionBase {
    readonly type: typeof Action.DISABLE;
    readonly payload: Payload;
}
export interface ConfirmAction extends ActionBase {
    readonly type: typeof Action.CONFIRM;
    readonly payload: Payload;
}
export declare function enable(payload?: Payload): EnableAction;
export declare function disable(payload?: Payload): DisableAction;
export declare function confirm(payload?: Payload): ConfirmAction;
/**
 * Leave Confirmation action set
 */
export declare class LeaveConfirmation extends ActionSet implements ActionSetProps<Options, Payload> {
    options: Options;
    /**
     * Returns a new instance of a Leave Confirmation action set
     * @param app the client application
     */
    constructor(app: ClientApplication, options?: Options);
    /**
     * Returns the action set payload
     */
    get payload(): Payload;
    set(options: Partial<Options>): this;
    /**
     * Dispatches a given action with the action set payload
     * @param action the action enum
     * @returns the action set instance
     */
    dispatch(action: Action): this;
}
