export type Gid<Namespace extends string, Type extends string> = `gid://${Namespace}/${Type}/${number | string}`;
export type ShopifyGid<T extends string> = Gid<'shopify', T>;
interface ParsedGid {
    id: string;
    params: {
        [key: string]: string;
    };
}
export declare function parseGidType(gid: string): string;
export declare function parseGid(gid: string): string;
export declare function parseGidWithParams(gid: string): ParsedGid;
export declare function composeGidFactory<N extends string>(namespace: N): <T extends string>(key: T, id: number | string, params?: {
    [key: string]: string;
}) => `gid://${N}/${T}/${string}` | `gid://${N}/${T}/${number}`;
export declare const composeGid: <T extends string>(key: T, id: number | string, params?: {
    [key: string]: string;
}) => `gid://shopify/${T}/${string}` | `gid://shopify/${T}/${number}`;
export declare function isGidFactory<N extends string>(namespace: N): <T extends string = string>(gid: string, key?: T | undefined) => gid is `gid://${N}/${T}/${string}` | `gid://${N}/${T}/${number}`;
export declare const isGid: <T extends string = string>(gid: string, key?: T | undefined) => gid is `gid://shopify/${T}/${string}` | `gid://shopify/${T}/${number}`;
interface Edge<T> {
    node: T;
}
export declare function nodesFromEdges<T>(edges: Edge<T>[]): T[];
export declare function keyFromEdges<T, K extends keyof T>(edges: Edge<T>[], key: K): T[K][];
export {};
//# sourceMappingURL=index.d.ts.map