import type { StaticHandlerContext } from "@remix-run/router";
import type { RouteManifest, EntryRoute } from "./routes";
import type { RouteModules } from "./routeModules";
type SerializedError = {
    message: string;
    stack?: string;
};
export interface RemixContextObject {
    manifest: AssetsManifest;
    routeModules: RouteModules;
    serverHandoffString?: string;
    future: FutureConfig;
    abortDelay?: number;
    dev?: {
        port: number;
    };
    serializeError?(error: Error): SerializedError;
}
export interface EntryContext extends RemixContextObject {
    staticHandlerContext: StaticHandlerContext;
}
type Dev = {
    port?: number;
    appServerPort?: number;
    remixRequestHandlerPath?: string;
    rebuildPollIntervalMs?: number;
};
export interface FutureConfig {
    v2_dev: boolean | Dev;
    /** @deprecated Use the `postcss` config option instead */
    unstable_postcss: boolean;
    /** @deprecated Use the `tailwind` config option instead */
    unstable_tailwind: boolean;
    v2_errorBoundary: boolean;
    v2_headers: boolean;
    v2_meta: boolean;
    v2_normalizeFormMethod: boolean;
    v2_routeConvention: boolean;
}
export interface AssetsManifest {
    entry: {
        imports: string[];
        module: string;
    };
    routes: RouteManifest<EntryRoute>;
    url: string;
    version: string;
    hmr?: {
        timestamp: number;
        runtime: string;
    };
}
export {};
