var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf, __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: !0 });
}, __copyProps = (to, from, except, desc) => {
  if (from && typeof from == "object" || typeof from == "function")
    for (let key of __getOwnPropNames(from))
      !__hasOwnProp.call(to, key) && key !== except && __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: !0 }) : target,
  mod
)), __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: !0 }), mod);

// <stdin>
var stdin_exports = {};
__export(stdin_exports, {
  assets: () => assets_manifest_default,
  assetsBuildDirectory: () => assetsBuildDirectory,
  entry: () => entry,
  future: () => future,
  publicPath: () => publicPath,
  routes: () => routes
});
module.exports = __toCommonJS(stdin_exports);

// app/entry.server.jsx
var entry_server_exports = {};
__export(entry_server_exports, {
  default: () => handleRequest
});
var import_stream = require("stream"), import_server = require("react-dom/server"), import_node2 = require("@remix-run/node"), import_react = require("@remix-run/react"), import_isbot = __toESM(require("isbot"));

// app/shopify.server.js
var import_node = require("@shopify/shopify-app-remix/adapters/node"), import_shopify_app_remix = require("@shopify/shopify-app-remix"), import_shopify_app_session_storage_prisma = require("@shopify/shopify-app-session-storage-prisma"), import__ = require("@shopify/shopify-api/rest/admin/2023-07");

// app/db.server.js
var import_client = require("@prisma/client"), prisma = global.prisma || new import_client.PrismaClient(), db_server_default = prisma;

// app/shopify.server.js
var _a, shopify2 = (0, import_shopify_app_remix.shopifyApp)({
  apiKey: process.env.SHOPIFY_API_KEY,
  apiSecretKey: process.env.SHOPIFY_API_SECRET || "",
  apiVersion: import_shopify_app_remix.LATEST_API_VERSION,
  scopes: (_a = process.env.SCOPES) == null ? void 0 : _a.split(","),
  appUrl: process.env.SHOPIFY_APP_URL || "",
  authPathPrefix: "/auth",
  sessionStorage: new import_shopify_app_session_storage_prisma.PrismaSessionStorage(db_server_default),
  distribution: import_shopify_app_remix.AppDistribution.AppStore,
  restResources: import__.restResources,
  webhooks: {
    APP_UNINSTALLED: {
      deliveryMethod: import_shopify_app_remix.DeliveryMethod.Http,
      callbackUrl: "/webhooks"
    }
  },
  hooks: {
    afterAuth: async ({ session }) => {
      shopify2.registerWebhooks({ session });
    }
  },
  ...process.env.SHOP_CUSTOM_DOMAIN ? { customShopDomains: [process.env.SHOP_CUSTOM_DOMAIN] } : {}
}), shopify_server_default = shopify2;
var addDocumentResponseHeaders = shopify2.addDocumentResponseHeaders, authenticate = shopify2.authenticate, login = shopify2.login, registerWebhooks = shopify2.registerWebhooks, sessionStorage = shopify2.sessionStorage;

// app/entry.server.jsx
var import_jsx_runtime = require("react/jsx-runtime"), ABORT_DELAY = 5e3;
async function handleRequest(request, responseStatusCode, responseHeaders, remixContext, _loadContext) {
  addDocumentResponseHeaders(request, responseHeaders);
  let callbackName = (0, import_isbot.default)(request.headers.get("user-agent")) ? "onAllReady" : "onShellReady";
  return new Promise((resolve, reject) => {
    let { pipe, abort } = (0, import_server.renderToPipeableStream)(
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
        import_react.RemixServer,
        {
          context: remixContext,
          url: request.url,
          abortDelay: ABORT_DELAY
        }
      ),
      {
        [callbackName]: () => {
          let body = new import_stream.PassThrough();
          responseHeaders.set("Content-Type", "text/html"), resolve(
            new import_node2.Response(body, {
              headers: responseHeaders,
              status: responseStatusCode
            })
          ), pipe(body);
        },
        onShellError(error) {
          reject(error);
        },
        onError(error) {
          responseStatusCode = 500, console.error(error);
        }
      }
    );
    setTimeout(abort, ABORT_DELAY);
  });
}

// app/root.jsx
var root_exports = {};
__export(root_exports, {
  default: () => App
});
var import_react2 = require("@remix-run/react"), import_jsx_runtime2 = require("react/jsx-runtime");
function App() {
  return /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)("html", { children: [
    /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)("head", { children: [
      /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("meta", { charSet: "utf-8" }),
      /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("meta", { name: "viewport", content: "width=device-width,initial-scale=1" }),
      /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_react2.Meta, {}),
      /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_react2.Links, {})
    ] }),
    /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)("body", { children: [
      /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_react2.Outlet, {}),
      /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_react2.ScrollRestoration, {}),
      /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_react2.LiveReload, {}),
      /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_react2.Scripts, {})
    ] })
  ] });
}

// app/routes/app.volume-discount.$functionId.$id.jsx
var app_volume_discount_functionId_id_exports = {};
__export(app_volume_discount_functionId_id_exports, {
  action: () => action,
  default: () => VolumeEdit,
  loader: () => loader
});
var import_react3 = require("react"), import_node3 = require("@remix-run/node"), import_react_form = require("@shopify/react-form"), import_app_bridge_react = require("@shopify/app-bridge-react"), import_actions = require("@shopify/app-bridge/actions"), import_react_i18n = require("@shopify/react-i18n"), import_react4 = require("@remix-run/react"), import_discount_app_components = require("@shopify/discount-app-components"), import_polaris2 = require("@shopify/polaris");

// app/components/NotFoundPage/NotFoundPage.jsx
var import_polaris = require("@shopify/polaris");

// app/components/NotFoundPage/empty-state.svg
var empty_state_default = "/build/_assets/empty-state-J7PKHSDM.svg";

// app/components/NotFoundPage/NotFoundPage.jsx
var import_jsx_runtime3 = require("react/jsx-runtime");
function NotFoundPage() {
  return /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_polaris.Page, { children: /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_polaris.Card, { children: /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(
    import_polaris.EmptyState,
    {
      heading: "There is no page at this address",
      image: empty_state_default,
      children: /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("p", { children: "Check the URL and try again, or use the search bar to find what you need." })
    }
  ) }) });
}

// app/routes/app.volume-discount.$functionId.$id.jsx
var import_jsx_runtime4 = require("react/jsx-runtime"), action = async ({ params, request }) => {
  var _a2, _b;
  let { id, functionId } = params, { admin } = await shopify_server_default.authenticate.admin(request), formData = await request.formData(), {
    title,
    method,
    code,
    combinesWith,
    usageLimit,
    appliesOncePerCustomer,
    startsAt,
    endsAt,
    configuration
  } = JSON.parse(formData.get("discount")), baseDiscount = {
    functionId,
    title,
    combinesWith,
    startsAt: new Date(startsAt),
    endsAt: endsAt && new Date(endsAt)
  };
  if (method === import_discount_app_components.DiscountMethod.Code) {
    let baseCodeDiscount = {
      ...baseDiscount,
      title: code,
      code,
      usageLimit,
      appliesOncePerCustomer
    }, errors = (_a2 = (await (await admin.graphql(
      `#graphql
          mutation UpdateCodeDiscount($id: ID!, $discount: DiscountCodeAppInput!) {
            discountUpdate: discountCodeAppUpdate(id: $id, codeAppDiscount: $discount) {
              userErrors {
                code
                message
                field
              }
            }
          }`,
      {
        variables: {
          id: `gid://shopify/DiscountCodeApp/${id}`,
          discount: {
            ...baseCodeDiscount,
            metafields: [
              {
                id: configuration.metafieldId,
                value: JSON.stringify({
                  quantity: configuration.quantity,
                  percentage: configuration.percentage,
                  orderAmount: configuration.orderAmount
                })
              }
            ]
          }
        }
      }
    )).json()).data.discountUpdate) == null ? void 0 : _a2.userErrors;
    return (0, import_node3.json)({ errors });
  } else {
    let errors = (_b = (await (await admin.graphql(
      `#graphql
          mutation UpdateAutomaticDiscount($id: ID!, $discount: DiscountAutomaticAppInput!) {
            discountUpdate: discountAutomaticAppUpdate(id: $id, automaticAppDiscount: $discount) {
              userErrors {
                code
                message
                field
              }
            }
          }`,
      {
        variables: {
          id: `gid://shopify/DiscountAutomaticApp/${id}`,
          discount: {
            ...baseDiscount,
            metafields: [
              {
                id: configuration.metafieldId,
                value: JSON.stringify({
                  quantity: configuration.quantity,
                  percentage: configuration.percentage,
                  orderAmount: configuration.orderAmount
                })
              }
            ]
          }
        }
      }
    )).json()).data.discountUpdate) == null ? void 0 : _b.userErrors;
    return (0, import_node3.json)({ errors });
  }
}, loader = async ({ params, request }) => {
  var _a2;
  let { id } = params, { admin } = await shopify_server_default.authenticate.admin(request), responseJson = await (await admin.graphql(
    `#graphql
      query GetDiscount($id: ID!) {
        discountNode(id: $id) {
          id
          configurationField: metafield(
            namespace: "$app:volume-discount"
            key: "function-configuration"
          ) {
            id
            value
          }
          discount {
            __typename
            ... on DiscountAutomaticApp {
              title
              discountClass
              combinesWith {
                orderDiscounts
                productDiscounts
                shippingDiscounts
              }
              startsAt
              endsAt
            }
            ... on DiscountCodeApp {
              title
              discountClass
              combinesWith {
                orderDiscounts
                productDiscounts
                shippingDiscounts
              }
              startsAt
              endsAt
              usageLimit
              appliesOncePerCustomer
              codes(first: 1) {
                nodes {
                  code
                }
              }
            }
          }
        }
      }`,
    {
      variables: {
        id: `gid://shopify/DiscountNode/${id}`
      }
    }
  )).json();
  if (!responseJson.data.discountNode || !responseJson.data.discountNode.discount)
    return (0, import_node3.json)({ discount: null });
  let method = responseJson.data.discountNode.discount.__typename === "DiscountCodeApp" ? import_discount_app_components.DiscountMethod.Code : import_discount_app_components.DiscountMethod.Automatic, {
    title,
    codes,
    combinesWith,
    usageLimit,
    appliesOncePerCustomer,
    startsAt,
    endsAt
  } = responseJson.data.discountNode.discount, configuration = JSON.parse(
    responseJson.data.discountNode.configurationField.value
  ), discount = {
    title,
    method,
    code: ((_a2 = codes == null ? void 0 : codes.nodes[0]) == null ? void 0 : _a2.code) ?? "",
    combinesWith,
    usageLimit: usageLimit ?? null,
    appliesOncePerCustomer: appliesOncePerCustomer ?? !1,
    startsAt,
    endsAt,
    configuration: {
      ...configuration,
      metafieldId: responseJson.data.discountNode.configurationField.id
    }
  };
  return (0, import_node3.json)({ discount });
};
function VolumeEdit() {
  let submitForm = (0, import_react4.useSubmit)(), actionData = (0, import_react4.useActionData)(), { discount } = (0, import_react4.useLoaderData)(), navigation = (0, import_react4.useNavigation)(), app = (0, import_app_bridge_react.useAppBridge)(), isLoading = navigation.state === "submitting", currencyCode = import_react_i18n.CurrencyCode.Cad, submitErrors = (actionData == null ? void 0 : actionData.errors) || [], redirect2 = import_actions.Redirect.create(app);
  if ((0, import_react3.useEffect)(() => {
    (actionData == null ? void 0 : actionData.errors.length) === 0 && redirect2.dispatch(import_actions.Redirect.Action.ADMIN_SECTION, {
      name: import_actions.Redirect.ResourceType.Discount
    });
  }, [actionData]), !discount)
    return /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(NotFoundPage, {});
  let { metafieldId } = discount.configuration, {
    fields: {
      discountTitle,
      discountCode,
      discountMethod,
      combinesWith,
      requirementType,
      requirementSubtotal,
      requirementQuantity,
      usageLimit,
      appliesOncePerCustomer,
      startDate,
      endDate,
      configuration
    },
    submit
  } = (0, import_react_form.useForm)({
    fields: {
      discountTitle: (0, import_react_form.useField)(discount.title),
      discountMethod: (0, import_react_form.useField)(discount.method),
      discountCode: (0, import_react_form.useField)(discount.code),
      combinesWith: (0, import_react_form.useField)(discount.combinesWith),
      requirementType: (0, import_react_form.useField)(import_discount_app_components.RequirementType.None),
      requirementSubtotal: (0, import_react_form.useField)("0"),
      requirementQuantity: (0, import_react_form.useField)("0"),
      usageLimit: (0, import_react_form.useField)(discount.usageLimit),
      appliesOncePerCustomer: (0, import_react_form.useField)(discount.appliesOncePerCustomer),
      startDate: (0, import_react_form.useField)(discount.startsAt),
      endDate: (0, import_react_form.useField)(discount.endsAt),
      configuration: {
        quantity: (0, import_react_form.useField)(discount.configuration.quantity),
        percentage: (0, import_react_form.useField)(discount.configuration.percentage),
        orderAmount: (0, import_react_form.useField)(discount.configuration.orderAmount)
      }
    },
    onSubmit: async (form) => {
      let discount2 = {
        title: form.discountTitle,
        method: form.discountMethod,
        code: form.discountCode,
        combinesWith: form.combinesWith,
        usageLimit: form.usageLimit == null ? null : parseInt(form.usageLimit),
        appliesOncePerCustomer: form.appliesOncePerCustomer,
        startsAt: form.startDate,
        endsAt: form.endDate,
        configuration: {
          metafieldId,
          quantity: parseInt(form.configuration.quantity),
          percentage: parseFloat(form.configuration.percentage),
          orderAmount: parseFloat(form.configuration.orderAmount)
        }
      };
      return submitForm({ discount: JSON.stringify(discount2) }, { method: "post" }), { status: "success" };
    }
  }), errorBanner = submitErrors.length > 0 ? /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(import_polaris2.Layout.Section, { children: /* @__PURE__ */ (0, import_jsx_runtime4.jsxs)(import_polaris2.Banner, { status: "critical", children: [
    /* @__PURE__ */ (0, import_jsx_runtime4.jsx)("p", { children: "There were some issues with your form submission:" }),
    /* @__PURE__ */ (0, import_jsx_runtime4.jsx)("ul", { children: submitErrors.map(({ message, field }, index) => /* @__PURE__ */ (0, import_jsx_runtime4.jsxs)("li", { children: [
      field.join("."),
      " ",
      message
    ] }, `${message}${index}`)) })
  ] }) }) : null;
  return (
    // Render a discount form using Polaris components and the discount app components
    /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(
      import_polaris2.Page,
      {
        title: "Create volume discount",
        backAction: {
          content: "Discounts",
          onAction: () => (0, import_discount_app_components.onBreadcrumbAction)(redirect2, !0)
        },
        primaryAction: {
          content: "Save",
          onAction: submit,
          loading: isLoading
        },
        children: /* @__PURE__ */ (0, import_jsx_runtime4.jsxs)(import_polaris2.Layout, { children: [
          errorBanner,
          /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(import_polaris2.Layout.Section, { children: /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(import_react4.Form, { method: "post", children: /* @__PURE__ */ (0, import_jsx_runtime4.jsxs)(import_polaris2.VerticalStack, { align: "space-around", gap: "2", children: [
            /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(
              import_discount_app_components.MethodCard,
              {
                title: "Volume",
                discountTitle,
                discountClass: import_discount_app_components.DiscountClass.Product,
                discountCode,
                discountMethod
              }
            ),
            /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(import_polaris2.Card, { children: /* @__PURE__ */ (0, import_jsx_runtime4.jsxs)(import_polaris2.VerticalStack, { gap: "3", children: [
              /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(import_polaris2.Text, { variant: "headingMd", as: "h2", children: "Volume" }),
              /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(
                import_polaris2.TextField,
                {
                  label: "Minimum quantity",
                  autoComplete: "on",
                  ...configuration.quantity
                }
              ),
              /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(
                import_polaris2.TextField,
                {
                  label: "Discount percentage",
                  autoComplete: "on",
                  ...configuration.percentage,
                  suffix: "%"
                }
              ),
              /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(
                import_polaris2.TextField,
                {
                  label: "Discount Apply when order amount more than",
                  autoComplete: "on",
                  ...configuration.orderAmount
                }
              )
            ] }) }),
            discountMethod.value === import_discount_app_components.DiscountMethod.Code && /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(
              import_discount_app_components.UsageLimitsCard,
              {
                totalUsageLimit: usageLimit,
                oncePerCustomer: appliesOncePerCustomer
              }
            ),
            /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(
              import_discount_app_components.CombinationCard,
              {
                combinableDiscountTypes: combinesWith,
                discountClass: import_discount_app_components.DiscountClass.Product,
                discountDescriptor: "Discount"
              }
            ),
            /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(
              import_discount_app_components.ActiveDatesCard,
              {
                startDate,
                endDate,
                timezoneAbbreviation: "EST"
              }
            )
          ] }) }) }),
          /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(import_polaris2.Layout.Section, { secondary: !0, children: /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(
            import_discount_app_components.SummaryCard,
            {
              header: {
                discountMethod: discountMethod.value,
                discountDescriptor: discountMethod.value === import_discount_app_components.DiscountMethod.Automatic ? discountTitle.value : discountCode.value,
                appDiscountType: "Volume",
                isEditing: !1
              },
              performance: {
                status: import_discount_app_components.DiscountStatus.Scheduled,
                usageCount: 0,
                isEditing: !1
              },
              minimumRequirements: {
                requirementType: requirementType.value,
                subtotal: requirementSubtotal.value,
                quantity: requirementQuantity.value,
                currencyCode
              },
              usageLimits: {
                oncePerCustomer: appliesOncePerCustomer.value,
                totalUsageLimit: usageLimit.value
              },
              activeDates: {
                startDate: startDate.value,
                endDate: endDate.value
              }
            }
          ) }),
          /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(import_polaris2.Layout.Section, { children: /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(
            import_polaris2.PageActions,
            {
              primaryAction: {
                content: "Save discount",
                onAction: submit,
                loading: isLoading
              },
              secondaryActions: [
                {
                  content: "Discard",
                  onAction: () => (0, import_discount_app_components.onBreadcrumbAction)(redirect2, !0)
                }
              ]
            }
          ) })
        ] })
      }
    )
  );
}

// app/routes/app.volume-discount.$functionId.new.jsx
var app_volume_discount_functionId_new_exports = {};
__export(app_volume_discount_functionId_new_exports, {
  action: () => action2,
  default: () => VolumeNew
});
var import_react5 = require("react"), import_node4 = require("@remix-run/node"), import_react_form2 = require("@shopify/react-form"), import_app_bridge_react2 = require("@shopify/app-bridge-react"), import_actions2 = require("@shopify/app-bridge/actions"), import_react_i18n2 = require("@shopify/react-i18n"), import_react6 = require("@remix-run/react"), import_discount_app_components2 = require("@shopify/discount-app-components"), import_polaris3 = require("@shopify/polaris");
var import_jsx_runtime5 = require("react/jsx-runtime"), action2 = async ({ params, request }) => {
  var _a2, _b;
  let { functionId } = params, { admin } = await shopify_server_default.authenticate.admin(request), formData = await request.formData(), {
    title,
    method,
    code,
    combinesWith,
    usageLimit,
    appliesOncePerCustomer,
    startsAt,
    endsAt,
    configuration
  } = JSON.parse(formData.get("discount")), baseDiscount = {
    functionId,
    title,
    combinesWith,
    startsAt: new Date(startsAt),
    endsAt: endsAt && new Date(endsAt)
  };
  if (method === import_discount_app_components2.DiscountMethod.Code) {
    let baseCodeDiscount = {
      ...baseDiscount,
      title: code,
      code,
      usageLimit,
      appliesOncePerCustomer
    }, errors = (_a2 = (await (await admin.graphql(
      `#graphql
          mutation CreateCodeDiscount($discount: DiscountCodeAppInput!) {
            discountCreate: discountCodeAppCreate(codeAppDiscount: $discount) {
              userErrors {
                code
                message
                field
              }
            }
          }`,
      {
        variables: {
          discount: {
            ...baseCodeDiscount,
            metafields: [
              {
                namespace: "$app:volume-discount",
                key: "function-configuration",
                type: "json",
                value: JSON.stringify({
                  quantity: configuration.quantity,
                  percentage: configuration.percentage,
                  orderAmount: configuration.orderAmount
                })
              }
            ]
          }
        }
      }
    )).json()).data.discountCreate) == null ? void 0 : _a2.userErrors;
    return (0, import_node4.json)({ errors });
  } else {
    let errors = (_b = (await (await admin.graphql(
      `#graphql
          mutation CreateAutomaticDiscount($discount: DiscountAutomaticAppInput!) {
            discountCreate: discountAutomaticAppCreate(automaticAppDiscount: $discount) {
              userErrors {
                code
                message
                field
              }
            }
          }`,
      {
        variables: {
          discount: {
            ...baseDiscount,
            metafields: [
              {
                namespace: "$app:volume-discount",
                key: "function-configuration",
                type: "json",
                value: JSON.stringify({
                  quantity: configuration.quantity,
                  percentage: configuration.percentage,
                  orderAmount: configuration.orderAmount
                })
              }
            ]
          }
        }
      }
    )).json()).data.discountCreate) == null ? void 0 : _b.userErrors;
    return (0, import_node4.json)({ errors });
  }
};
function VolumeNew() {
  let submitForm = (0, import_react6.useSubmit)(), actionData = (0, import_react6.useActionData)(), navigation = (0, import_react6.useNavigation)(), app = (0, import_app_bridge_react2.useAppBridge)(), todaysDate = (0, import_react5.useMemo)(() => /* @__PURE__ */ new Date(), []), isLoading = navigation.state === "submitting", currencyCode = import_react_i18n2.CurrencyCode.Cad, submitErrors = (actionData == null ? void 0 : actionData.errors) || [], redirect2 = import_actions2.Redirect.create(app);
  (0, import_react5.useEffect)(() => {
    (actionData == null ? void 0 : actionData.errors.length) === 0 && redirect2.dispatch(import_actions2.Redirect.Action.ADMIN_SECTION, {
      name: import_actions2.Redirect.ResourceType.Discount
    });
  }, [actionData]);
  let {
    fields: {
      discountTitle,
      discountCode,
      discountMethod,
      combinesWith,
      requirementType,
      requirementSubtotal,
      requirementQuantity,
      usageLimit,
      appliesOncePerCustomer,
      startDate,
      endDate,
      configuration
    },
    submit
  } = (0, import_react_form2.useForm)({
    fields: {
      discountTitle: (0, import_react_form2.useField)(""),
      discountMethod: (0, import_react_form2.useField)(import_discount_app_components2.DiscountMethod.Code),
      discountCode: (0, import_react_form2.useField)(""),
      combinesWith: (0, import_react_form2.useField)({
        orderDiscounts: !1,
        productDiscounts: !1,
        shippingDiscounts: !1
      }),
      requirementType: (0, import_react_form2.useField)(import_discount_app_components2.RequirementType.None),
      requirementSubtotal: (0, import_react_form2.useField)("0"),
      requirementQuantity: (0, import_react_form2.useField)("0"),
      usageLimit: (0, import_react_form2.useField)(null),
      appliesOncePerCustomer: (0, import_react_form2.useField)(!1),
      startDate: (0, import_react_form2.useField)(todaysDate),
      endDate: (0, import_react_form2.useField)(null),
      configuration: {
        quantity: (0, import_react_form2.useField)("0"),
        percentage: (0, import_react_form2.useField)("0"),
        orderAmount: (0, import_react_form2.useField)("0")
      }
    },
    onSubmit: async (form) => {
      let discount = {
        title: form.discountTitle,
        method: form.discountMethod,
        code: form.discountCode,
        combinesWith: form.combinesWith,
        usageLimit: form.usageLimit == null ? null : parseInt(form.usageLimit),
        appliesOncePerCustomer: form.appliesOncePerCustomer,
        startsAt: form.startDate,
        endsAt: form.endDate,
        configuration: {
          quantity: parseInt(form.configuration.quantity),
          percentage: parseFloat(form.configuration.percentage),
          orderAmount: parseFloat(form.configuration.orderAmount)
        }
      };
      return submitForm({ discount: JSON.stringify(discount) }, { method: "post" }), { status: "success" };
    }
  }), errorBanner = submitErrors.length > 0 ? /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(import_polaris3.Layout.Section, { children: /* @__PURE__ */ (0, import_jsx_runtime5.jsxs)(import_polaris3.Banner, { status: "critical", children: [
    /* @__PURE__ */ (0, import_jsx_runtime5.jsx)("p", { children: "There were some issues with your form submission:" }),
    /* @__PURE__ */ (0, import_jsx_runtime5.jsx)("ul", { children: submitErrors.map(({ message, field }, index) => /* @__PURE__ */ (0, import_jsx_runtime5.jsxs)("li", { children: [
      field.join("."),
      " ",
      message
    ] }, `${message}${index}`)) })
  ] }) }) : null;
  return (
    // Render a discount form using Polaris components and the discount app components
    /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(
      import_polaris3.Page,
      {
        title: "Create volume discount",
        backAction: {
          content: "Discounts",
          onAction: () => (0, import_discount_app_components2.onBreadcrumbAction)(redirect2, !0)
        },
        primaryAction: {
          content: "Save",
          onAction: submit,
          loading: isLoading
        },
        children: /* @__PURE__ */ (0, import_jsx_runtime5.jsxs)(import_polaris3.Layout, { children: [
          errorBanner,
          /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(import_polaris3.Layout.Section, { children: /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(import_react6.Form, { method: "post", children: /* @__PURE__ */ (0, import_jsx_runtime5.jsxs)(import_polaris3.VerticalStack, { align: "space-around", gap: "2", children: [
            /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(
              import_discount_app_components2.MethodCard,
              {
                title: "Volume",
                discountTitle,
                discountClass: import_discount_app_components2.DiscountClass.Product,
                discountCode,
                discountMethod
              }
            ),
            /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(import_polaris3.Card, { children: /* @__PURE__ */ (0, import_jsx_runtime5.jsxs)(import_polaris3.VerticalStack, { gap: "3", children: [
              /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(import_polaris3.Text, { variant: "headingMd", as: "h2", children: "Volume" }),
              /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(
                import_polaris3.TextField,
                {
                  label: "Minimum quantity",
                  autoComplete: "on",
                  ...configuration.quantity
                }
              ),
              /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(
                import_polaris3.TextField,
                {
                  label: "Discount percentage",
                  autoComplete: "on",
                  ...configuration.percentage,
                  suffix: "%"
                }
              ),
              /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(
                import_polaris3.TextField,
                {
                  label: "Discount Apply when order amount more than",
                  autoComplete: "on",
                  ...configuration.orderAmount
                }
              )
            ] }) }),
            discountMethod.value === import_discount_app_components2.DiscountMethod.Code && /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(
              import_discount_app_components2.UsageLimitsCard,
              {
                totalUsageLimit: usageLimit,
                oncePerCustomer: appliesOncePerCustomer
              }
            ),
            /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(
              import_discount_app_components2.CombinationCard,
              {
                combinableDiscountTypes: combinesWith,
                discountClass: import_discount_app_components2.DiscountClass.Product,
                discountDescriptor: "Discount"
              }
            ),
            /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(
              import_discount_app_components2.ActiveDatesCard,
              {
                startDate,
                endDate,
                timezoneAbbreviation: "EST"
              }
            )
          ] }) }) }),
          /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(import_polaris3.Layout.Section, { secondary: !0, children: /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(
            import_discount_app_components2.SummaryCard,
            {
              header: {
                discountMethod: discountMethod.value,
                discountDescriptor: discountMethod.value === import_discount_app_components2.DiscountMethod.Automatic ? discountTitle.value : discountCode.value,
                appDiscountType: "Volume",
                isEditing: !1
              },
              performance: {
                status: import_discount_app_components2.DiscountStatus.Scheduled,
                usageCount: 0,
                isEditing: !1
              },
              minimumRequirements: {
                requirementType: requirementType.value,
                subtotal: requirementSubtotal.value,
                quantity: requirementQuantity.value,
                currencyCode
              },
              usageLimits: {
                oncePerCustomer: appliesOncePerCustomer.value,
                totalUsageLimit: usageLimit.value
              },
              activeDates: {
                startDate: startDate.value,
                endDate: endDate.value
              }
            }
          ) }),
          /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(import_polaris3.Layout.Section, { children: /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(
            import_polaris3.PageActions,
            {
              primaryAction: {
                content: "Save discount",
                onAction: submit,
                loading: isLoading
              },
              secondaryActions: [
                {
                  content: "Discard",
                  onAction: () => (0, import_discount_app_components2.onBreadcrumbAction)(redirect2, !0)
                }
              ]
            }
          ) })
        ] })
      }
    )
  );
}

// app/routes/app.additional.jsx
var app_additional_exports = {};
__export(app_additional_exports, {
  default: () => AdditionalPage
});
var import_polaris4 = require("@shopify/polaris"), import_jsx_runtime6 = require("react/jsx-runtime");
function AdditionalPage() {
  return /* @__PURE__ */ (0, import_jsx_runtime6.jsxs)(import_polaris4.Page, { children: [
    /* @__PURE__ */ (0, import_jsx_runtime6.jsx)("ui-title-bar", { title: "Additional page" }),
    /* @__PURE__ */ (0, import_jsx_runtime6.jsxs)(import_polaris4.Layout, { children: [
      /* @__PURE__ */ (0, import_jsx_runtime6.jsx)(import_polaris4.Layout.Section, { children: /* @__PURE__ */ (0, import_jsx_runtime6.jsx)(import_polaris4.Card, { children: /* @__PURE__ */ (0, import_jsx_runtime6.jsxs)(import_polaris4.VerticalStack, { gap: "3", children: [
        /* @__PURE__ */ (0, import_jsx_runtime6.jsxs)(import_polaris4.Text, { as: "p", variant: "bodyMd", children: [
          "The app template comes with an additional page which demonstrates how to create multiple pages within app navigation using",
          " ",
          /* @__PURE__ */ (0, import_jsx_runtime6.jsx)(
            import_polaris4.Link,
            {
              url: "https://shopify.dev/docs/apps/tools/app-bridge",
              target: "_blank",
              children: "App Bridge"
            }
          ),
          "."
        ] }),
        /* @__PURE__ */ (0, import_jsx_runtime6.jsxs)(import_polaris4.Text, { as: "p", variant: "bodyMd", children: [
          "To create your own page and have it show up in the app navigation, add a page inside ",
          /* @__PURE__ */ (0, import_jsx_runtime6.jsx)(Code, { children: "app/routes" }),
          ", and a link to it in the ",
          /* @__PURE__ */ (0, import_jsx_runtime6.jsx)(Code, { children: "<ui-nav-menu>" }),
          " component found in ",
          /* @__PURE__ */ (0, import_jsx_runtime6.jsx)(Code, { children: "app/routes/app.jsx" }),
          "."
        ] })
      ] }) }) }),
      /* @__PURE__ */ (0, import_jsx_runtime6.jsx)(import_polaris4.Layout.Section, { secondary: !0, children: /* @__PURE__ */ (0, import_jsx_runtime6.jsx)(import_polaris4.Card, { children: /* @__PURE__ */ (0, import_jsx_runtime6.jsxs)(import_polaris4.VerticalStack, { gap: "2", children: [
        /* @__PURE__ */ (0, import_jsx_runtime6.jsx)(import_polaris4.Text, { as: "h2", variant: "headingMd", children: "Resources" }),
        /* @__PURE__ */ (0, import_jsx_runtime6.jsx)(import_polaris4.List, { spacing: "extraTight", children: /* @__PURE__ */ (0, import_jsx_runtime6.jsx)(import_polaris4.List.Item, { children: /* @__PURE__ */ (0, import_jsx_runtime6.jsx)(
          import_polaris4.Link,
          {
            url: "https://shopify.dev/docs/apps/design-guidelines/navigation#app-nav",
            target: "_blank",
            children: "App nav best practices"
          }
        ) }) })
      ] }) }) })
    ] })
  ] });
}
function Code({ children }) {
  return /* @__PURE__ */ (0, import_jsx_runtime6.jsx)(
    import_polaris4.Box,
    {
      as: "span",
      padding: "025",
      paddingInlineStart: "1",
      paddingInlineEnd: "1",
      background: "bg-subdued",
      borderWidth: "1",
      borderColor: "border",
      borderRadius: "1",
      children: /* @__PURE__ */ (0, import_jsx_runtime6.jsx)("code", { children })
    }
  );
}

// app/routes/app._index.jsx
var app_index_exports = {};
__export(app_index_exports, {
  action: () => action3,
  default: () => Index,
  loader: () => loader2
});
var import_react7 = require("react"), import_node5 = require("@remix-run/node"), import_react8 = require("@remix-run/react"), import_polaris5 = require("@shopify/polaris");
var import_jsx_runtime7 = require("react/jsx-runtime"), loader2 = async ({ request }) => {
  let { session } = await authenticate.admin(request);
  return (0, import_node5.json)({ shop: session.shop.replace(".myshopify.com", "") });
};
async function action3({ request }) {
  let { admin } = await authenticate.admin(request), color = ["Red", "Orange", "Yellow", "Green"][Math.floor(Math.random() * 4)], responseJson = await (await admin.graphql(
    `#graphql
      mutation populateProduct($input: ProductInput!) {
        productCreate(input: $input) {
          product {
            id
            title
            handle
            status
            variants(first: 10) {
              edges {
                node {
                  id
                  price
                  barcode
                  createdAt
                }
              }
            }
          }
        }
      }`,
    {
      variables: {
        input: {
          title: `${color} Snowboard`,
          variants: [{ price: Math.random() * 100 }]
        }
      }
    }
  )).json();
  return (0, import_node5.json)({
    product: responseJson.data.productCreate.product
  });
}
function Index() {
  var _a2;
  let nav = (0, import_react8.useNavigation)(), { shop } = (0, import_react8.useLoaderData)(), actionData = (0, import_react8.useActionData)(), submit = (0, import_react8.useSubmit)(), isLoading = ["loading", "submitting"].includes(nav.state) && nav.formMethod === "POST", productId = (_a2 = actionData == null ? void 0 : actionData.product) == null ? void 0 : _a2.id.replace(
    "gid://shopify/Product/",
    ""
  );
  (0, import_react7.useEffect)(() => {
    productId && shopify.toast.show("Product created");
  }, [productId]);
  let generateProduct = () => submit({}, { replace: !0, method: "POST" });
  return /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)(import_polaris5.Page, { children: [
    /* @__PURE__ */ (0, import_jsx_runtime7.jsx)("ui-title-bar", { title: "Remix app template", children: /* @__PURE__ */ (0, import_jsx_runtime7.jsx)("button", { variant: "primary", onClick: generateProduct, children: "Generate a product" }) }),
    /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_polaris5.VerticalStack, { gap: "5", children: /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)(import_polaris5.Layout, { children: [
      /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_polaris5.Layout.Section, { children: /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_polaris5.Card, { children: /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)(import_polaris5.VerticalStack, { gap: "5", children: [
        /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)(import_polaris5.VerticalStack, { gap: "2", children: [
          /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_polaris5.Text, { as: "h2", variant: "headingMd", children: "Congrats on creating a new Shopify app \u{1F389}" }),
          /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)(import_polaris5.Text, { variant: "bodyMd", as: "p", children: [
            "This embedded app template uses",
            " ",
            /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(
              import_polaris5.Link,
              {
                url: "https://shopify.dev/docs/apps/tools/app-bridge",
                target: "_blank",
                children: "App Bridge"
              }
            ),
            " ",
            "interface examples like an",
            " ",
            /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_polaris5.Link, { url: "/app/additional", children: "additional page in the app nav" }),
            ", as well as an",
            " ",
            /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(
              import_polaris5.Link,
              {
                url: "https://shopify.dev/docs/api/admin-graphql",
                target: "_blank",
                children: "Admin GraphQL"
              }
            ),
            " ",
            "mutation demo, to provide a starting point for app development."
          ] })
        ] }),
        /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)(import_polaris5.VerticalStack, { gap: "2", children: [
          /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_polaris5.Text, { as: "h3", variant: "headingMd", children: "Get started with products" }),
          /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)(import_polaris5.Text, { as: "p", variant: "bodyMd", children: [
            "Generate a product with GraphQL and get the JSON output for that product. Learn more about the",
            " ",
            /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(
              import_polaris5.Link,
              {
                url: "https://shopify.dev/docs/api/admin-graphql/latest/mutations/productCreate",
                target: "_blank",
                children: "productCreate"
              }
            ),
            " ",
            "mutation in our API references."
          ] })
        ] }),
        /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)(import_polaris5.HorizontalStack, { gap: "3", align: "end", children: [
          (actionData == null ? void 0 : actionData.product) && /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(
            import_polaris5.Button,
            {
              url: `https://admin.shopify.com/store/${shop}/admin/products/${productId}`,
              target: "_blank",
              children: "View product"
            }
          ),
          /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_polaris5.Button, { loading: isLoading, primary: !0, onClick: generateProduct, children: "Generate a product" })
        ] }),
        (actionData == null ? void 0 : actionData.product) && /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(
          import_polaris5.Box,
          {
            padding: "4",
            background: "bg-subdued",
            borderColor: "border",
            borderWidth: "1",
            borderRadius: "2",
            overflowX: "scroll",
            children: /* @__PURE__ */ (0, import_jsx_runtime7.jsx)("pre", { style: { margin: 0 }, children: /* @__PURE__ */ (0, import_jsx_runtime7.jsx)("code", { children: JSON.stringify(actionData.product, null, 2) }) })
          }
        )
      ] }) }) }),
      /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_polaris5.Layout.Section, { secondary: !0, children: /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)(import_polaris5.VerticalStack, { gap: "5", children: [
        /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_polaris5.Card, { children: /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)(import_polaris5.VerticalStack, { gap: "2", children: [
          /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_polaris5.Text, { as: "h2", variant: "headingMd", children: "App template specs" }),
          /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)(import_polaris5.VerticalStack, { gap: "2", children: [
            /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_polaris5.Divider, {}),
            /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)(import_polaris5.HorizontalStack, { align: "space-between", children: [
              /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_polaris5.Text, { as: "span", variant: "bodyMd", children: "Framework" }),
              /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_polaris5.Link, { url: "https://remix.run", target: "_blank", children: "Remix" })
            ] }),
            /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_polaris5.Divider, {}),
            /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)(import_polaris5.HorizontalStack, { align: "space-between", children: [
              /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_polaris5.Text, { as: "span", variant: "bodyMd", children: "Database" }),
              /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_polaris5.Link, { url: "https://www.prisma.io/", target: "_blank", children: "Prisma" })
            ] }),
            /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_polaris5.Divider, {}),
            /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)(import_polaris5.HorizontalStack, { align: "space-between", children: [
              /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_polaris5.Text, { as: "span", variant: "bodyMd", children: "Interface" }),
              /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)("span", { children: [
                /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_polaris5.Link, { url: "https://polaris.shopify.com", target: "_blank", children: "Polaris" }),
                ", ",
                /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(
                  import_polaris5.Link,
                  {
                    url: "https://shopify.dev/docs/apps/tools/app-bridge",
                    target: "_blank",
                    children: "App Bridge"
                  }
                )
              ] })
            ] }),
            /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_polaris5.Divider, {}),
            /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)(import_polaris5.HorizontalStack, { align: "space-between", children: [
              /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_polaris5.Text, { as: "span", variant: "bodyMd", children: "API" }),
              /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(
                import_polaris5.Link,
                {
                  url: "https://shopify.dev/docs/api/admin-graphql",
                  target: "_blank",
                  children: "GraphQL API"
                }
              )
            ] })
          ] })
        ] }) }),
        /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_polaris5.Card, { children: /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)(import_polaris5.VerticalStack, { gap: "2", children: [
          /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_polaris5.Text, { as: "h2", variant: "headingMd", children: "Next steps" }),
          /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)(import_polaris5.List, { spacing: "extraTight", children: [
            /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)(import_polaris5.List.Item, { children: [
              "Build an",
              " ",
              /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)(
                import_polaris5.Link,
                {
                  url: "https://shopify.dev/docs/apps/getting-started/build-app-example",
                  target: "_blank",
                  children: [
                    " ",
                    "example app"
                  ]
                }
              ),
              " ",
              "to get started"
            ] }),
            /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)(import_polaris5.List.Item, { children: [
              "Explore Shopify\u2019s API with",
              " ",
              /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(
                import_polaris5.Link,
                {
                  url: "https://shopify.dev/docs/apps/tools/graphiql-admin-api",
                  target: "_blank",
                  children: "GraphiQL"
                }
              )
            ] })
          ] })
        ] }) })
      ] }) })
    ] }) })
  ] });
}

// app/routes/auth.login/route.jsx
var route_exports = {};
__export(route_exports, {
  action: () => action4,
  default: () => Auth,
  links: () => links,
  loader: () => loader3
});
var import_react9 = require("react"), import_node6 = require("@remix-run/node"), import_polaris6 = require("@shopify/polaris"), import_react10 = require("@remix-run/react");

// node_modules/@shopify/polaris/build/esm/styles.css
var styles_default = "/build/_assets/styles-VSOLUTS4.css";

// app/routes/auth.login/error.server.jsx
var import_shopify_app_remix2 = require("@shopify/shopify-app-remix");
function loginErrorMessage(loginErrors) {
  return (loginErrors == null ? void 0 : loginErrors.shop) === import_shopify_app_remix2.LoginErrorType.MissingShop ? { shop: "Please enter your shop domain to log in" } : (loginErrors == null ? void 0 : loginErrors.shop) === import_shopify_app_remix2.LoginErrorType.InvalidShop ? { shop: "Please enter a valid shop domain to log in" } : {};
}

// app/routes/auth.login/route.jsx
var import_jsx_runtime8 = require("react/jsx-runtime"), links = () => [{ rel: "stylesheet", href: styles_default }];
async function loader3({ request }) {
  let errors = loginErrorMessage(await login(request));
  return (0, import_node6.json)({
    errors,
    polarisTranslations: require("@shopify/polaris/locales/en.json")
  });
}
async function action4({ request }) {
  let errors = loginErrorMessage(await login(request));
  return (0, import_node6.json)({
    errors
  });
}
function Auth() {
  let { polarisTranslations } = (0, import_react10.useLoaderData)(), loaderData = (0, import_react10.useLoaderData)(), actionData = (0, import_react10.useActionData)(), [shop, setShop] = (0, import_react9.useState)(""), { errors } = actionData || loaderData;
  return /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(import_polaris6.AppProvider, { i18n: polarisTranslations, children: /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(import_polaris6.Page, { children: /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(import_polaris6.Card, { children: /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(import_react10.Form, { method: "post", children: /* @__PURE__ */ (0, import_jsx_runtime8.jsxs)(import_polaris6.FormLayout, { children: [
    /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(import_polaris6.Text, { variant: "headingMd", as: "h2", children: "Log in" }),
    /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(
      import_polaris6.TextField,
      {
        type: "text",
        name: "shop",
        label: "Shop domain",
        helpText: "example.myshopify.com",
        value: shop,
        onChange: setShop,
        autoComplete: "on",
        error: errors.shop
      }
    ),
    /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(import_polaris6.Button, { submit: !0, children: "Log in" })
  ] }) }) }) }) });
}

// app/routes/webhooks.jsx
var webhooks_exports = {};
__export(webhooks_exports, {
  action: () => action5
});
var action5 = async ({ request }) => {
  let { topic, shop } = await authenticate.webhook(request);
  switch (topic) {
    case "APP_UNINSTALLED":
      await db_server_default.session.deleteMany({ where: { shop } });
      break;
    case "CUSTOMERS_DATA_REQUEST":
    case "CUSTOMERS_REDACT":
    case "SHOP_REDACT":
    default:
      throw new Response("Unhandled webhook topic", { status: 404 });
  }
  throw new Response();
};

// app/routes/_index/route.jsx
var route_exports2 = {};
__export(route_exports2, {
  default: () => App2,
  links: () => links2,
  loader: () => loader4
});
var import_node7 = require("@remix-run/node"), import_react11 = require("@remix-run/react");

// app/routes/_index/style.css
var style_default = "/build/_assets/style-6S2Q7E3W.css";

// app/routes/_index/route.jsx
var import_jsx_runtime9 = require("react/jsx-runtime"), links2 = () => [{ rel: "stylesheet", href: style_default }];
async function loader4({ request }) {
  let url = new URL(request.url);
  if (url.searchParams.get("shop"))
    throw (0, import_node7.redirect)(`/app?${url.searchParams.toString()}`);
  return (0, import_node7.json)({ showForm: Boolean(login) });
}
function App2() {
  let { showForm } = (0, import_react11.useLoaderData)();
  return /* @__PURE__ */ (0, import_jsx_runtime9.jsx)("div", { className: "index", children: /* @__PURE__ */ (0, import_jsx_runtime9.jsxs)("div", { className: "content", children: [
    /* @__PURE__ */ (0, import_jsx_runtime9.jsx)("h1", { children: "A short heading about [your app]" }),
    /* @__PURE__ */ (0, import_jsx_runtime9.jsx)("p", { children: "A tagline about [your app] that describes your value proposition." }),
    showForm && /* @__PURE__ */ (0, import_jsx_runtime9.jsxs)(import_react11.Form, { method: "post", action: "/auth/login", children: [
      /* @__PURE__ */ (0, import_jsx_runtime9.jsxs)("label", { children: [
        /* @__PURE__ */ (0, import_jsx_runtime9.jsx)("span", { children: "Shop domain" }),
        /* @__PURE__ */ (0, import_jsx_runtime9.jsx)("input", { type: "text", name: "shop" }),
        /* @__PURE__ */ (0, import_jsx_runtime9.jsx)("span", { children: "e.g: my-shop-domain.myshopify.com" })
      ] }),
      /* @__PURE__ */ (0, import_jsx_runtime9.jsx)("button", { type: "submit", children: "Log in" })
    ] }),
    /* @__PURE__ */ (0, import_jsx_runtime9.jsxs)("ul", { children: [
      /* @__PURE__ */ (0, import_jsx_runtime9.jsxs)("li", { children: [
        /* @__PURE__ */ (0, import_jsx_runtime9.jsx)("strong", { children: "Product feature" }),
        ". Some detail about your feature and its benefit to your customer."
      ] }),
      /* @__PURE__ */ (0, import_jsx_runtime9.jsxs)("li", { children: [
        /* @__PURE__ */ (0, import_jsx_runtime9.jsx)("strong", { children: "Product feature" }),
        ". Some detail about your feature and its benefit to your customer."
      ] }),
      /* @__PURE__ */ (0, import_jsx_runtime9.jsxs)("li", { children: [
        /* @__PURE__ */ (0, import_jsx_runtime9.jsx)("strong", { children: "Product feature" }),
        ". Some detail about your feature and its benefit to your customer."
      ] })
    ] })
  ] }) });
}

// app/routes/auth.$.jsx
var auth_exports = {};
__export(auth_exports, {
  loader: () => loader5
});
async function loader5({ request }) {
  return await authenticate.admin(request), null;
}

// app/routes/app.jsx
var app_exports = {};
__export(app_exports, {
  ErrorBoundary: () => ErrorBoundary,
  default: () => App3,
  headers: () => headers,
  links: () => links3,
  loader: () => loader6
});
var import_react12 = require("react"), import_node8 = require("@remix-run/node"), import_react13 = require("@remix-run/react"), import_polaris7 = require("@shopify/polaris"), import_app_bridge_react3 = require("@shopify/app-bridge-react");

// app/components/providers/DiscountProvider.jsx
var import_discount_app_components3 = require("@shopify/discount-app-components");
var import_jsx_runtime10 = require("react/jsx-runtime");
function DiscountProvider({ children }) {
  return /* @__PURE__ */ (0, import_jsx_runtime10.jsx)(import_discount_app_components3.AppProvider, { locale: "en-US", ianaTimezone: "America/Toronto", children });
}

// app/routes/app.jsx
var import_jsx_runtime11 = require("react/jsx-runtime"), links3 = () => [{ rel: "stylesheet", href: styles_default }];
async function loader6({ request }) {
  await authenticate.admin(request);
  let url = new URL(request.url);
  return (0, import_node8.json)({
    polarisTranslations: require("@shopify/polaris/locales/en.json"),
    apiKey: process.env.SHOPIFY_API_KEY,
    host: url.searchParams.get("host")
  });
}
function App3() {
  let { apiKey, host, polarisTranslations } = (0, import_react13.useLoaderData)(), [config] = (0, import_react12.useState)({ host, apiKey });
  return /* @__PURE__ */ (0, import_jsx_runtime11.jsxs)(import_jsx_runtime11.Fragment, { children: [
    /* @__PURE__ */ (0, import_jsx_runtime11.jsx)(
      "script",
      {
        src: "https://cdn.shopify.com/shopifycloud/app-bridge.js",
        "data-api-key": apiKey
      }
    ),
    /* @__PURE__ */ (0, import_jsx_runtime11.jsx)(import_polaris7.AppProvider, { i18n: polarisTranslations, children: /* @__PURE__ */ (0, import_jsx_runtime11.jsx)(import_app_bridge_react3.Provider, { config, children: /* @__PURE__ */ (0, import_jsx_runtime11.jsx)(DiscountProvider, { children: /* @__PURE__ */ (0, import_jsx_runtime11.jsx)(import_react13.Outlet, {}) }) }) })
  ] });
}
function ErrorBoundary() {
  throw (0, import_react13.useRouteError)();
}
var headers = ({
  loaderHeaders,
  actionHeaders,
  errorHeaders,
  parentHeaders
}) => new Headers(
  [
    ...actionHeaders ? Array.from(actionHeaders.entries()) : [],
    ...loaderHeaders ? Array.from(loaderHeaders.entries()) : [],
    ...errorHeaders ? Array.from(errorHeaders.entries()) : [],
    ...parentHeaders ? Array.from(parentHeaders.entries()) : []
  ]
);

// server-assets-manifest:@remix-run/dev/assets-manifest
var assets_manifest_default = { entry: { module: "/build/entry.client-3PY4RYOX.js", imports: ["/build/_shared/chunk-W425JQQX.js", "/build/_shared/chunk-YZBVNK3V.js", "/build/_shared/chunk-GDLBX7ER.js", "/build/_shared/chunk-Q3IECNXJ.js"] }, routes: { root: { id: "root", parentId: void 0, path: "", index: void 0, caseSensitive: void 0, module: "/build/root-BJHWJGH7.js", imports: void 0, hasAction: !1, hasLoader: !1, hasCatchBoundary: !1, hasErrorBoundary: !1 }, "routes/_index": { id: "routes/_index", parentId: "root", path: void 0, index: !0, caseSensitive: void 0, module: "/build/routes/_index-72R4FY7T.js", imports: ["/build/_shared/chunk-WK3XIJ7S.js", "/build/_shared/chunk-PGOH7JLP.js"], hasAction: !1, hasLoader: !0, hasCatchBoundary: !1, hasErrorBoundary: !1 }, "routes/app": { id: "routes/app", parentId: "root", path: "app", index: void 0, caseSensitive: void 0, module: "/build/routes/app-T3ERLFKG.js", imports: ["/build/_shared/chunk-YWVS3NDG.js", "/build/_shared/chunk-WF3ETG76.js", "/build/_shared/chunk-S2N3QYIY.js", "/build/_shared/chunk-PGOH7JLP.js", "/build/_shared/chunk-BMXPJU7P.js"], hasAction: !1, hasLoader: !0, hasCatchBoundary: !1, hasErrorBoundary: !0 }, "routes/app._index": { id: "routes/app._index", parentId: "routes/app", path: void 0, index: !0, caseSensitive: void 0, module: "/build/routes/app._index-4LN2VT4F.js", imports: void 0, hasAction: !0, hasLoader: !0, hasCatchBoundary: !1, hasErrorBoundary: !1 }, "routes/app.additional": { id: "routes/app.additional", parentId: "routes/app", path: "additional", index: void 0, caseSensitive: void 0, module: "/build/routes/app.additional-OBEQNIET.js", imports: void 0, hasAction: !1, hasLoader: !1, hasCatchBoundary: !1, hasErrorBoundary: !1 }, "routes/app.volume-discount.$functionId.$id": { id: "routes/app.volume-discount.$functionId.$id", parentId: "routes/app", path: "volume-discount/:functionId/:id", index: void 0, caseSensitive: void 0, module: "/build/routes/app.volume-discount.$functionId.$id-TNAOY57Y.js", imports: ["/build/_shared/chunk-DA73XD7L.js"], hasAction: !0, hasLoader: !0, hasCatchBoundary: !1, hasErrorBoundary: !1 }, "routes/app.volume-discount.$functionId.new": { id: "routes/app.volume-discount.$functionId.new", parentId: "routes/app", path: "volume-discount/:functionId/new", index: void 0, caseSensitive: void 0, module: "/build/routes/app.volume-discount.$functionId.new-3VPK336D.js", imports: ["/build/_shared/chunk-DA73XD7L.js"], hasAction: !0, hasLoader: !1, hasCatchBoundary: !1, hasErrorBoundary: !1 }, "routes/auth.$": { id: "routes/auth.$", parentId: "root", path: "auth/*", index: void 0, caseSensitive: void 0, module: "/build/routes/auth.$-JID2MVQG.js", imports: void 0, hasAction: !1, hasLoader: !0, hasCatchBoundary: !1, hasErrorBoundary: !1 }, "routes/auth.login": { id: "routes/auth.login", parentId: "root", path: "auth/login", index: void 0, caseSensitive: void 0, module: "/build/routes/auth.login-R2P7XJUX.js", imports: ["/build/_shared/chunk-WK3XIJ7S.js", "/build/_shared/chunk-S2N3QYIY.js", "/build/_shared/chunk-PGOH7JLP.js", "/build/_shared/chunk-BMXPJU7P.js"], hasAction: !0, hasLoader: !0, hasCatchBoundary: !1, hasErrorBoundary: !1 }, "routes/webhooks": { id: "routes/webhooks", parentId: "root", path: "webhooks", index: void 0, caseSensitive: void 0, module: "/build/routes/webhooks-U3VAOICH.js", imports: void 0, hasAction: !0, hasLoader: !1, hasCatchBoundary: !1, hasErrorBoundary: !1 } }, version: "71e99f00", hmr: void 0, url: "/build/manifest-71E99F00.js" };

// server-entry-module:@remix-run/dev/server-build
var assetsBuildDirectory = "public/build", future = { v2_dev: { port: 8002 }, unstable_postcss: !1, unstable_tailwind: !1, v2_errorBoundary: !0, v2_headers: !0, v2_meta: !0, v2_normalizeFormMethod: !0, v2_routeConvention: !0 }, publicPath = "/build/", entry = { module: entry_server_exports }, routes = {
  root: {
    id: "root",
    parentId: void 0,
    path: "",
    index: void 0,
    caseSensitive: void 0,
    module: root_exports
  },
  "routes/app.volume-discount.$functionId.$id": {
    id: "routes/app.volume-discount.$functionId.$id",
    parentId: "routes/app",
    path: "volume-discount/:functionId/:id",
    index: void 0,
    caseSensitive: void 0,
    module: app_volume_discount_functionId_id_exports
  },
  "routes/app.volume-discount.$functionId.new": {
    id: "routes/app.volume-discount.$functionId.new",
    parentId: "routes/app",
    path: "volume-discount/:functionId/new",
    index: void 0,
    caseSensitive: void 0,
    module: app_volume_discount_functionId_new_exports
  },
  "routes/app.additional": {
    id: "routes/app.additional",
    parentId: "routes/app",
    path: "additional",
    index: void 0,
    caseSensitive: void 0,
    module: app_additional_exports
  },
  "routes/app._index": {
    id: "routes/app._index",
    parentId: "routes/app",
    path: void 0,
    index: !0,
    caseSensitive: void 0,
    module: app_index_exports
  },
  "routes/auth.login": {
    id: "routes/auth.login",
    parentId: "root",
    path: "auth/login",
    index: void 0,
    caseSensitive: void 0,
    module: route_exports
  },
  "routes/webhooks": {
    id: "routes/webhooks",
    parentId: "root",
    path: "webhooks",
    index: void 0,
    caseSensitive: void 0,
    module: webhooks_exports
  },
  "routes/_index": {
    id: "routes/_index",
    parentId: "root",
    path: void 0,
    index: !0,
    caseSensitive: void 0,
    module: route_exports2
  },
  "routes/auth.$": {
    id: "routes/auth.$",
    parentId: "root",
    path: "auth/*",
    index: void 0,
    caseSensitive: void 0,
    module: auth_exports
  },
  "routes/app": {
    id: "routes/app",
    parentId: "root",
    path: "app",
    index: void 0,
    caseSensitive: void 0,
    module: app_exports
  }
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  assets,
  assetsBuildDirectory,
  entry,
  future,
  publicPath,
  routes
});
