import {
  useField,
  useForm
} from "/build/_shared/chunk-76ASRIKV.js";
import {
  ActiveDatesCard,
  CombinationCard,
  CurrencyCode,
  DiscountClass,
  DiscountMethod,
  DiscountStatus,
  MethodCard,
  RequirementType,
  SummaryCard,
  UsageLimitsCard,
  onBreadcrumbAction,
  require_actions,
  require_app_bridge_react
} from "/build/_shared/chunk-N5DSUWFB.js";
import {
  require_shopify
} from "/build/_shared/chunk-SU66BP3D.js";
import {
  require_node
} from "/build/_shared/chunk-G7CHZRZX.js";
import {
  Form,
  useActionData,
  useNavigation,
  useSubmit
} from "/build/_shared/chunk-JA4VWRSL.js";
import {
  Banner,
  Card,
  Layout,
  Page,
  PageActions,
  Text,
  TextField,
  VerticalStack
} from "/build/_shared/chunk-7ULSSQR5.js";
import "/build/_shared/chunk-GIAAE3CH.js";
import {
  require_jsx_dev_runtime
} from "/build/_shared/chunk-XU7DNSPJ.js";
import {
  createHotContext
} from "/build/_shared/chunk-26POGGSR.js";
import "/build/_shared/chunk-UWV35TSL.js";
import {
  require_react
} from "/build/_shared/chunk-BOXFZXVX.js";
import {
  __toESM
} from "/build/_shared/chunk-PNG5AS42.js";

// app/routes/app.volume-discount.$functionId.new.jsx
var import_react = __toESM(require_react());
var import_node = __toESM(require_node());
var import_app_bridge_react = __toESM(require_app_bridge_react());
var import_actions = __toESM(require_actions());
var import_shopify = __toESM(require_shopify());
var import_jsx_dev_runtime = __toESM(require_jsx_dev_runtime());
if (!window.$RefreshReg$ || !window.$RefreshSig$ || !window.$RefreshRuntime$) {
  console.warn("remix:hmr: React Fast Refresh only works when the Remix compiler is running in development mode.");
} else {
  prevRefreshReg = window.$RefreshReg$;
  prevRefreshSig = window.$RefreshSig$;
  window.$RefreshReg$ = (type, id) => {
    window.$RefreshRuntime$.register(type, '"app/routes/app.volume-discount.$functionId.new.jsx"' + id);
  };
  window.$RefreshSig$ = window.$RefreshRuntime$.createSignatureFunctionForTransform;
}
var prevRefreshReg;
var prevRefreshSig;
var _s = $RefreshSig$();
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app/routes/app.volume-discount.$functionId.new.jsx"
  );
  import.meta.hot.lastModified = "1692707127304.1743";
}
function VolumeNew() {
  _s();
  const submitForm = useSubmit();
  const actionData = useActionData();
  const navigation = useNavigation();
  const app = (0, import_app_bridge_react.useAppBridge)();
  const todaysDate = (0, import_react.useMemo)(() => /* @__PURE__ */ new Date(), []);
  const isLoading = navigation.state === "submitting";
  const currencyCode = CurrencyCode.Cad;
  const submitErrors = (actionData == null ? void 0 : actionData.errors) || [];
  const redirect = import_actions.Redirect.create(app);
  (0, import_react.useEffect)(() => {
    if ((actionData == null ? void 0 : actionData.errors.length) === 0) {
      redirect.dispatch(import_actions.Redirect.Action.ADMIN_SECTION, {
        name: import_actions.Redirect.ResourceType.Discount
      });
    }
  }, [actionData]);
  const {
    fields: {
      discountTitle,
      discountCode,
      discountMethod,
      combinesWith,
      requirementType,
      requirementSubtotal,
      requirementQuantity,
      usageLimit,
      appliesOncePerCustomer,
      startDate,
      endDate,
      configuration
    },
    submit
  } = useForm({
    fields: {
      discountTitle: useField(""),
      discountMethod: useField(DiscountMethod.Code),
      discountCode: useField(""),
      combinesWith: useField({
        orderDiscounts: false,
        productDiscounts: false,
        shippingDiscounts: false
      }),
      requirementType: useField(RequirementType.None),
      requirementSubtotal: useField("0"),
      requirementQuantity: useField("0"),
      usageLimit: useField(null),
      appliesOncePerCustomer: useField(false),
      startDate: useField(todaysDate),
      endDate: useField(null),
      configuration: {
        quantity: useField("0"),
        percentage: useField("0"),
        orderAmount: useField("0")
      }
    },
    onSubmit: async (form) => {
      const discount = {
        title: form.discountTitle,
        method: form.discountMethod,
        code: form.discountCode,
        combinesWith: form.combinesWith,
        usageLimit: form.usageLimit == null ? null : parseInt(form.usageLimit),
        appliesOncePerCustomer: form.appliesOncePerCustomer,
        startsAt: form.startDate,
        endsAt: form.endDate,
        configuration: {
          quantity: parseInt(form.configuration.quantity),
          percentage: parseFloat(form.configuration.percentage),
          orderAmount: parseFloat(form.configuration.orderAmount)
        }
      };
      submitForm({
        discount: JSON.stringify(discount)
      }, {
        method: "post"
      });
      return {
        status: "success"
      };
    }
  });
  const errorBanner = submitErrors.length > 0 ? /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Layout.Section, { children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Banner, { status: "critical", children: [
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("p", { children: "There were some issues with your form submission:" }, void 0, false, {
      fileName: "app/routes/app.volume-discount.$functionId.new.jsx",
      lineNumber: 224,
      columnNumber: 11
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("ul", { children: submitErrors.map(({
      message,
      field
    }, index) => {
      return /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("li", { children: [
        field.join("."),
        " ",
        message
      ] }, `${message}${index}`, true, {
        fileName: "app/routes/app.volume-discount.$functionId.new.jsx",
        lineNumber: 230,
        columnNumber: 18
      }, this);
    }) }, void 0, false, {
      fileName: "app/routes/app.volume-discount.$functionId.new.jsx",
      lineNumber: 225,
      columnNumber: 11
    }, this)
  ] }, void 0, true, {
    fileName: "app/routes/app.volume-discount.$functionId.new.jsx",
    lineNumber: 223,
    columnNumber: 9
  }, this) }, void 0, false, {
    fileName: "app/routes/app.volume-discount.$functionId.new.jsx",
    lineNumber: 222,
    columnNumber: 49
  }, this) : null;
  return (
    // Render a discount form using Polaris components and the discount app components
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Page, { title: "Create volume discount", backAction: {
      content: "Discounts",
      onAction: () => onBreadcrumbAction(redirect, true)
    }, primaryAction: {
      content: "Save",
      onAction: submit,
      loading: isLoading
    }, children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Layout, { children: [
      errorBanner,
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Layout.Section, { children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Form, { method: "post", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(VerticalStack, { align: "space-around", gap: "2", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(MethodCard, { title: "Volume", discountTitle, discountClass: DiscountClass.Product, discountCode, discountMethod }, void 0, false, {
          fileName: "app/routes/app.volume-discount.$functionId.new.jsx",
          lineNumber: 252,
          columnNumber: 15
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Card, { children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(VerticalStack, { gap: "3", children: [
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Text, { variant: "headingMd", as: "h2", children: "Volume" }, void 0, false, {
            fileName: "app/routes/app.volume-discount.$functionId.new.jsx",
            lineNumber: 255,
            columnNumber: 19
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(TextField, { label: "Minimum quantity", autoComplete: "on", ...configuration.quantity }, void 0, false, {
            fileName: "app/routes/app.volume-discount.$functionId.new.jsx",
            lineNumber: 258,
            columnNumber: 19
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(TextField, { label: "Discount percentage", autoComplete: "on", ...configuration.percentage, suffix: "%" }, void 0, false, {
            fileName: "app/routes/app.volume-discount.$functionId.new.jsx",
            lineNumber: 259,
            columnNumber: 19
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(TextField, { label: "Discount Apply when order amount more than", autoComplete: "on", ...configuration.orderAmount }, void 0, false, {
            fileName: "app/routes/app.volume-discount.$functionId.new.jsx",
            lineNumber: 260,
            columnNumber: 22
          }, this)
        ] }, void 0, true, {
          fileName: "app/routes/app.volume-discount.$functionId.new.jsx",
          lineNumber: 254,
          columnNumber: 17
        }, this) }, void 0, false, {
          fileName: "app/routes/app.volume-discount.$functionId.new.jsx",
          lineNumber: 253,
          columnNumber: 15
        }, this),
        discountMethod.value === DiscountMethod.Code && /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(UsageLimitsCard, { totalUsageLimit: usageLimit, oncePerCustomer: appliesOncePerCustomer }, void 0, false, {
          fileName: "app/routes/app.volume-discount.$functionId.new.jsx",
          lineNumber: 263,
          columnNumber: 64
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(CombinationCard, { combinableDiscountTypes: combinesWith, discountClass: DiscountClass.Product, discountDescriptor: "Discount" }, void 0, false, {
          fileName: "app/routes/app.volume-discount.$functionId.new.jsx",
          lineNumber: 264,
          columnNumber: 15
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(ActiveDatesCard, { startDate, endDate, timezoneAbbreviation: "EST" }, void 0, false, {
          fileName: "app/routes/app.volume-discount.$functionId.new.jsx",
          lineNumber: 265,
          columnNumber: 15
        }, this)
      ] }, void 0, true, {
        fileName: "app/routes/app.volume-discount.$functionId.new.jsx",
        lineNumber: 251,
        columnNumber: 13
      }, this) }, void 0, false, {
        fileName: "app/routes/app.volume-discount.$functionId.new.jsx",
        lineNumber: 250,
        columnNumber: 11
      }, this) }, void 0, false, {
        fileName: "app/routes/app.volume-discount.$functionId.new.jsx",
        lineNumber: 249,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Layout.Section, { secondary: true, children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(SummaryCard, { header: {
        discountMethod: discountMethod.value,
        discountDescriptor: discountMethod.value === DiscountMethod.Automatic ? discountTitle.value : discountCode.value,
        appDiscountType: "Volume",
        isEditing: false
      }, performance: {
        status: DiscountStatus.Scheduled,
        usageCount: 0,
        isEditing: false
      }, minimumRequirements: {
        requirementType: requirementType.value,
        subtotal: requirementSubtotal.value,
        quantity: requirementQuantity.value,
        currencyCode
      }, usageLimits: {
        oncePerCustomer: appliesOncePerCustomer.value,
        totalUsageLimit: usageLimit.value
      }, activeDates: {
        startDate: startDate.value,
        endDate: endDate.value
      } }, void 0, false, {
        fileName: "app/routes/app.volume-discount.$functionId.new.jsx",
        lineNumber: 270,
        columnNumber: 11
      }, this) }, void 0, false, {
        fileName: "app/routes/app.volume-discount.$functionId.new.jsx",
        lineNumber: 269,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Layout.Section, { children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(PageActions, { primaryAction: {
        content: "Save discount",
        onAction: submit,
        loading: isLoading
      }, secondaryActions: [{
        content: "Discard",
        onAction: () => onBreadcrumbAction(redirect, true)
      }] }, void 0, false, {
        fileName: "app/routes/app.volume-discount.$functionId.new.jsx",
        lineNumber: 293,
        columnNumber: 11
      }, this) }, void 0, false, {
        fileName: "app/routes/app.volume-discount.$functionId.new.jsx",
        lineNumber: 292,
        columnNumber: 9
      }, this)
    ] }, void 0, true, {
      fileName: "app/routes/app.volume-discount.$functionId.new.jsx",
      lineNumber: 247,
      columnNumber: 7
    }, this) }, void 0, false, {
      fileName: "app/routes/app.volume-discount.$functionId.new.jsx",
      lineNumber: 239,
      columnNumber: 5
    }, this)
  );
}
_s(VolumeNew, "6/btSw8CQL/PWw+8yb6aLbxE4rM=", false, function() {
  return [useSubmit, useActionData, useNavigation, import_app_bridge_react.useAppBridge, useForm, useField, useField, useField, useField, useField, useField, useField, useField, useField, useField, useField, useField, useField, useField];
});
_c = VolumeNew;
var _c;
$RefreshReg$(_c, "VolumeNew");
window.$RefreshReg$ = prevRefreshReg;
window.$RefreshSig$ = prevRefreshSig;
export {
  VolumeNew as default
};
//# sourceMappingURL=/build/routes/app.volume-discount.$functionId.new-4XB56PSB.js.map
