import { MetricRatingThresholds, LCPReportCallback, ReportOpts } from './types.js';
/** Thresholds for LCP. See https://web.dev/lcp/#what-is-a-good-lcp-score */
export declare const LCPThresholds: MetricRatingThresholds;
/**
 * Calculates the [LCP](https://web.dev/lcp/) value for the current page and
 * calls the `callback` function once the value is ready (along with the
 * relevant `largest-contentful-paint` performance entry used to determine the
 * value). The reported value is a `DOMHighResTimeStamp`.
 *
 * If the `reportAllChanges` configuration option is set to `true`, the
 * `callback` function will be called any time a new `largest-contentful-paint`
 * performance entry is dispatched, or once the final value of the metric has
 * been determined.
 */
export declare const onLCP: (onReport: LCPReportCallback, opts?: ReportOpts) => void;
