import type * as Dom from './types.dom.js';
import type { BatchRequestDocument, BatchRequestsOptions, RawRequestExtendedOptions, RawRequestOptions, RequestDocument, RequestExtendedOptions, RequestOptions, Variables, VariablesAndRequestHeadersArgs } from './types.js';
export declare const parseRequestArgs: <V extends Variables = Variables>(documentOrOptions: RequestDocument | RequestOptions<V, unknown>, variables?: V | undefined, requestHeaders?: Dom.RequestInit['headers']) => RequestOptions<V, unknown>;
export declare const parseRawRequestArgs: <V extends Variables = Variables>(queryOrOptions: string | RawRequestOptions<V>, variables?: V | undefined, requestHeaders?: Dom.RequestInit['headers']) => RawRequestOptions<V>;
export declare const parseBatchRequestArgs: <V extends Variables = Variables>(documentsOrOptions: BatchRequestsOptions<V> | BatchRequestDocument<V>[], requestHeaders?: Dom.RequestInit['headers']) => BatchRequestsOptions<V>;
export declare const parseRequestExtendedArgs: <V extends Variables = Variables>(urlOrOptions: string | RequestExtendedOptions<V, unknown>, document?: RequestDocument, ...variablesAndRequestHeaders: VariablesAndRequestHeadersArgs<V>) => RequestExtendedOptions<V, unknown>;
export declare const parseRawRequestExtendedArgs: <V extends Variables = Variables>(urlOrOptions: string | RawRequestExtendedOptions<V>, query?: string, ...variablesAndRequestHeaders: VariablesAndRequestHeadersArgs<V>) => RawRequestExtendedOptions<V>;
//# sourceMappingURL=parseArgs.d.ts.map