"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MissingSessionTableError = exports.PrismaSessionStorage = void 0;
var tslib_1 = require("tslib");
// import type {PrismaClient} from '@prisma/client';
var shopify_api_1 = require("@shopify/shopify-api");
var PrismaSessionStorage = /** @class */ (function () {
    function PrismaSessionStorage(prisma) {
        this.prisma = prisma;
        if (this.prisma.session === undefined) {
            throw new Error('PrismaClient does not have a Session table');
        }
        this.ready = this.prisma.session.count().catch(function () {
            throw new MissingSessionTableError('Prisma Session table does not exist. This could happen for a few reasons, see https://github.com/Shopify/shopify-app-js/tree/main/packages/shopify-app-session-storage-prisma#troubleshooting for more information');
        });
    }
    PrismaSessionStorage.prototype.storeSession = function (session) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var data;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.ready];
                    case 1:
                        _a.sent();
                        data = this.sessionToRow(session);
                        return [4 /*yield*/, this.prisma.session.upsert({
                                where: { id: session.id },
                                update: data,
                                create: data,
                            })];
                    case 2:
                        _a.sent();
                        return [2 /*return*/, true];
                }
            });
        });
    };
    PrismaSessionStorage.prototype.loadSession = function (id) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var row;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.ready];
                    case 1:
                        _a.sent();
                        return [4 /*yield*/, this.prisma.session.findUnique({
                                where: { id: id },
                            })];
                    case 2:
                        row = _a.sent();
                        if (!row) {
                            return [2 /*return*/, undefined];
                        }
                        return [2 /*return*/, this.rowToSession(row)];
                }
            });
        });
    };
    PrismaSessionStorage.prototype.deleteSession = function (id) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var _a;
            return tslib_1.__generator(this, function (_b) {
                switch (_b.label) {
                    case 0: return [4 /*yield*/, this.ready];
                    case 1:
                        _b.sent();
                        _b.label = 2;
                    case 2:
                        _b.trys.push([2, 4, , 5]);
                        return [4 /*yield*/, this.prisma.session.delete({ where: { id: id } })];
                    case 3:
                        _b.sent();
                        return [3 /*break*/, 5];
                    case 4:
                        _a = _b.sent();
                        return [2 /*return*/, true];
                    case 5: return [2 /*return*/, true];
                }
            });
        });
    };
    PrismaSessionStorage.prototype.deleteSessions = function (ids) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.ready];
                    case 1:
                        _a.sent();
                        return [4 /*yield*/, this.prisma.session.deleteMany({ where: { id: { in: ids } } })];
                    case 2:
                        _a.sent();
                        return [2 /*return*/, true];
                }
            });
        });
    };
    PrismaSessionStorage.prototype.findSessionsByShop = function (shop) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var sessions;
            var _this = this;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.ready];
                    case 1:
                        _a.sent();
                        return [4 /*yield*/, this.prisma.session.findMany({
                                where: { shop: shop },
                                take: 25,
                                orderBy: [{ expires: 'desc' }],
                            })];
                    case 2:
                        sessions = _a.sent();
                        return [2 /*return*/, sessions.map(function (session) { return _this.rowToSession(session); })];
                }
            });
        });
    };
    PrismaSessionStorage.prototype.sessionToRow = function (session) {
        var _a;
        var sessionParams = session.toObject();
        return {
            id: session.id,
            shop: session.shop,
            state: session.state,
            isOnline: session.isOnline,
            scope: session.scope || null,
            expires: session.expires || null,
            accessToken: session.accessToken || '',
            userId: ((_a = sessionParams.onlineAccessInfo) === null || _a === void 0 ? void 0 : _a.associated_user.id) || null,
        };
    };
    PrismaSessionStorage.prototype.rowToSession = function (row) {
        var sessionParams = {
            id: row.id,
            shop: row.shop,
            state: row.state,
            isOnline: row.isOnline,
        };
        if (row.expires) {
            sessionParams.expires = row.expires.getTime();
        }
        if (row.scope) {
            sessionParams.scope = row.scope;
        }
        if (row.accessToken) {
            sessionParams.accessToken = row.accessToken;
        }
        if (row.userId) {
            sessionParams.onlineAccessInfo = String(row.userId);
        }
        return shopify_api_1.Session.fromPropertyArray(Object.entries(sessionParams));
    };
    return PrismaSessionStorage;
}());
exports.PrismaSessionStorage = PrismaSessionStorage;
var MissingSessionTableError = /** @class */ (function (_super) {
    tslib_1.__extends(MissingSessionTableError, _super);
    function MissingSessionTableError() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return MissingSessionTableError;
}(Error));
exports.MissingSessionTableError = MissingSessionTableError;
//# sourceMappingURL=prisma.js.map