import { Session } from '@shopify/shopify-api';
import { SessionStorage } from '@shopify/shopify-app-session-storage';
import type { PrismaClient } from '@prisma/client';
export declare class PrismaSessionStorage<T extends PrismaClient> implements SessionStorage {
    private prisma;
    private ready;
    constructor(prisma: T);
    storeSession(session: Session): Promise<boolean>;
    loadSession(id: string): Promise<Session | undefined>;
    deleteSession(id: string): Promise<boolean>;
    deleteSessions(ids: string[]): Promise<boolean>;
    findSessionsByShop(shop: string): Promise<Session[]>;
    private sessionToRow;
    private rowToSession;
}
export declare class MissingSessionTableError extends Error {
}
//# sourceMappingURL=prisma.d.ts.map