"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.overrideLogger = void 0;
var tslib_1 = require("tslib");
var semver_1 = tslib_1.__importDefault(require("semver"));
var shopify_api_1 = require("@shopify/shopify-api");
var version_1 = require("./version");
// eslint-disable-next-line no-warning-comments
// TODO This has been copied from shopify-app-express, it should be extracted into a shared package
// https://github.com/orgs/Shopify/projects/6899/views/1?pane=issue&itemId=28358070
function overrideLogger(logger) {
    var baseContext = { package: 'shopify-app' };
    var warningFunction = function (message, context) {
        if (context === void 0) { context = {}; }
        return logger.warning(message, tslib_1.__assign(tslib_1.__assign({}, baseContext), context));
    };
    function deprecated(warningFunction) {
        return function (version, message) {
            if (semver_1.default.gte(version_1.SHOPIFY_REMIX_LIBRARY_VERSION, version)) {
                throw new shopify_api_1.FeatureDeprecatedError("Feature was deprecated in version ".concat(version));
            }
            return warningFunction("[Deprecated | ".concat(version, "] ").concat(message));
        };
    }
    return tslib_1.__assign(tslib_1.__assign({}, logger), { log: function (severity, message, context) {
            if (context === void 0) { context = {}; }
            return logger.log(severity, message, tslib_1.__assign(tslib_1.__assign({}, baseContext), context));
        }, debug: function (message, context) {
            if (context === void 0) { context = {}; }
            return logger.debug(message, tslib_1.__assign(tslib_1.__assign({}, baseContext), context));
        }, info: function (message, context) {
            if (context === void 0) { context = {}; }
            return logger.info(message, tslib_1.__assign(tslib_1.__assign({}, baseContext), context));
        }, warning: warningFunction, error: function (message, context) {
            if (context === void 0) { context = {}; }
            return logger.error(message, tslib_1.__assign(tslib_1.__assign({}, baseContext), context));
        }, deprecated: deprecated(warningFunction) });
}
exports.overrideLogger = overrideLogger;
//# sourceMappingURL=override-logger.js.map