import '@shopify/shopify-api/adapters/web-api';
import { ShopifyRestResources } from '@shopify/shopify-api';
import { SessionStorage } from '@shopify/shopify-app-session-storage';
import { type AppConfigArg } from './config-types';
import { type ShopifyApp } from './types';
import { headersBoundary } from './boundary/headers';
import { errorBoundary } from './boundary/error';
export type { ShopifyApp, LoginError } from './types';
export { LoginErrorType, AppDistribution } from './types';
export { LATEST_API_VERSION, LogSeverity, DeliveryMethod, BillingInterval, ApiVersion, } from '@shopify/shopify-api';
/**
 * Creates an object your app will use to interact with Shopify.
 *
 * @param appConfig Configuration options for your shopify app.  For example, the scopes your app needs.
 * @returns `ShopifyApp` An object constructed using your appConfig.  It has methods for interacting with Shopify.
 *
 * @example
 * The minimum viable configuration
 * ```ts
 * import { shopifyApp } from "@shopify/shopify-app-remix";
 *
 * const shopify = shopifyApp({
 *   apiKey: process.env.SHOPIFY_API_KEY!,
 *   apiSecretKey: process.env.SHOPIFY_API_SECRET!,
 *   scopes: process.env.SCOPES?.split(",")!,
 *   appUrl: process.env.SHOPIFY_APP_URL!,
 * });
 * export default shopify;
 * ```
 */
export declare function shopifyApp<Config extends AppConfigArg<Resources, Storage>, Resources extends ShopifyRestResources, Storage extends SessionStorage>(appConfig: Config): ShopifyApp<Config>;
/**
 * A collection of functions that handle the necessary code for error boundaries in routes using authenticate.admin.
 */
export declare const boundary: {
    /**
     * A function that handles errors or thrown responses.
     *
     * @example
     * Catching errors in a route
     * ```ts
     * // app/routes/admin/widgets.ts
     * import { boundary } from "@shopify/shopify-app-remix";
     *
     * export function ErrorBoundary() {
     *   return boundary.error(useRouteError());
     * }
     * ```
     */
    error: typeof errorBoundary;
    /**
     * A function that sets the appropriate document repsonse headers.
     *
     * @example
     * Catching errors in a route
     * ```ts
     * // app/routes/admin/widgets.ts
     * import { boundary } from "@shopify/shopify-app-remix";
     *
     * export const headers = (headersArgs) => {
     *   return boundary.headers(headersArgs);
     * };
     * ```
     */
    headers: typeof headersBoundary;
};
//# sourceMappingURL=index.d.ts.map