"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.requireBillingFactory = void 0;
var tslib_1 = require("tslib");
var shopify_api_1 = require("@shopify/shopify-api");
var helpers_1 = require("../auth/helpers");
function requireBillingFactory(params, request, session) {
    var api = params.api, logger = params.logger;
    return function requireBilling(options) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var logContext, data, error_1;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        logContext = {
                            shop: session.shop,
                            plans: options.plans,
                            isTest: options.isTest,
                        };
                        logger.debug('Checking billing for the shop', logContext);
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 3, , 7]);
                        return [4 /*yield*/, api.billing.check({
                                session: session,
                                plans: options.plans,
                                isTest: options.isTest,
                                returnObject: true,
                            })];
                    case 2:
                        data = _a.sent();
                        return [3 /*break*/, 7];
                    case 3:
                        error_1 = _a.sent();
                        if (!(error_1 instanceof shopify_api_1.HttpResponseError && error_1.response.code === 401)) return [3 /*break*/, 5];
                        logger.debug('API token was invalid, redirecting to OAuth', logContext);
                        return [4 /*yield*/, (0, helpers_1.redirectToAuthPage)(params, request, session.shop)];
                    case 4: throw _a.sent();
                    case 5: throw error_1;
                    case 6: return [3 /*break*/, 7];
                    case 7:
                        if (!!data.hasActivePayment) return [3 /*break*/, 9];
                        logger.debug('Billing check failed', logContext);
                        return [4 /*yield*/, options.onFailure(new Error('Billing check failed'))];
                    case 8: throw _a.sent();
                    case 9:
                        logger.debug('Billing check succeeded', logContext);
                        return [2 /*return*/, data];
                }
            });
        });
    };
}
exports.requireBillingFactory = requireBillingFactory;
//# sourceMappingURL=require.js.map