"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.requestBillingFactory = void 0;
var tslib_1 = require("tslib");
var shopify_api_1 = require("@shopify/shopify-api");
var server_runtime_1 = require("@remix-run/server-runtime");
var helpers_1 = require("../auth/helpers");
var redirect_with_app_bridge_headers_1 = require("../auth/helpers/redirect-with-app-bridge-headers");
function requestBillingFactory(params, request, session) {
    return function requestBilling(_a) {
        var plan = _a.plan, isTest = _a.isTest, returnUrl = _a.returnUrl;
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var api, logger, result, error_1;
            return tslib_1.__generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        api = params.api, logger = params.logger;
                        logger.info('Requesting billing', {
                            shop: session.shop,
                            plan: plan,
                            isTest: isTest,
                            returnUrl: returnUrl,
                        });
                        _b.label = 1;
                    case 1:
                        _b.trys.push([1, 3, , 7]);
                        return [4 /*yield*/, api.billing.request({
                                plan: plan,
                                session: session,
                                isTest: isTest,
                                returnUrl: returnUrl,
                                returnObject: true,
                            })];
                    case 2:
                        result = _b.sent();
                        return [3 /*break*/, 7];
                    case 3:
                        error_1 = _b.sent();
                        if (!(error_1 instanceof shopify_api_1.HttpResponseError && error_1.response.code === 401)) return [3 /*break*/, 5];
                        logger.debug('API token was invalid, redirecting to OAuth', {
                            shop: session.shop,
                        });
                        return [4 /*yield*/, (0, helpers_1.redirectToAuthPage)(params, request, session.shop)];
                    case 4: throw _b.sent();
                    case 5: throw error_1;
                    case 6: return [3 /*break*/, 7];
                    case 7: throw redirectOutOfApp(params, request, result.confirmationUrl, session.shop);
                }
            });
        });
    };
}
exports.requestBillingFactory = requestBillingFactory;
function redirectOutOfApp(params, request, url, shop) {
    var config = params.config, logger = params.logger;
    logger.debug('Redirecting out of app', { url: url });
    var requestUrl = new URL(request.url);
    var isEmbeddedRequest = requestUrl.searchParams.get('embedded') === '1';
    var isXhrRequest = request.headers.get('authorization');
    if (isXhrRequest) {
        // eslint-disable-next-line no-warning-comments
        // TODO Check this with the beta flag disabled (with the bounce page)
        // Remix is not including the X-Shopify-API-Request-Failure-Reauthorize-Url when throwing a Response
        // https://github.com/remix-run/remix/issues/5356
        throw new Response(undefined, {
            status: 401,
            statusText: 'Unauthorized',
            headers: (0, redirect_with_app_bridge_headers_1.getAppBridgeHeaders)(url),
        });
    }
    else if (isEmbeddedRequest) {
        var params_1 = new URLSearchParams({
            shop: shop,
            host: requestUrl.searchParams.get('host'),
            exitIframe: url,
        });
        throw (0, server_runtime_1.redirect)("".concat(config.auth.exitIframePath, "?").concat(params_1.toString()));
    }
    else {
        // This will only ever happen for non-embedded apps, because the authenticator will stop before reaching this point
        throw (0, server_runtime_1.redirect)(url);
    }
}
//# sourceMappingURL=request.js.map