"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.cancelBillingFactory = void 0;
var tslib_1 = require("tslib");
var shopify_api_1 = require("@shopify/shopify-api");
var helpers_1 = require("../auth/helpers");
function cancelBillingFactory(params, request, session) {
    return function cancelBilling(options) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var api, logger, error_1;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        api = params.api, logger = params.logger;
                        logger.debug('Cancelling billing', tslib_1.__assign({ shop: session.shop }, options));
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 3, , 7]);
                        return [4 /*yield*/, api.billing.cancel({
                                session: session,
                                subscriptionId: options.subscriptionId,
                                isTest: options.isTest,
                                prorate: options.prorate,
                            })];
                    case 2: return [2 /*return*/, _a.sent()];
                    case 3:
                        error_1 = _a.sent();
                        if (!(error_1 instanceof shopify_api_1.HttpResponseError && error_1.response.code === 401)) return [3 /*break*/, 5];
                        logger.debug('API token was invalid, redirecting to OAuth', {
                            shop: session.shop,
                        });
                        return [4 /*yield*/, (0, helpers_1.redirectToAuthPage)(params, request, session.shop)];
                    case 4: throw _a.sent();
                    case 5: throw error_1;
                    case 6: return [3 /*break*/, 7];
                    case 7: return [2 /*return*/];
                }
            });
        });
    };
}
exports.cancelBillingFactory = cancelBillingFactory;
//# sourceMappingURL=cancel.js.map