"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.loginFactory = void 0;
var tslib_1 = require("tslib");
var server_runtime_1 = require("@remix-run/server-runtime");
var types_1 = require("../../types");
function loginFactory(params) {
    var api = params.api, config = params.config, logger = params.logger;
    return function login(request) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var url, shopParam, shop, _a, shopWithoutProtocol, shopWithDomain, sanitizedShop, redirectUrl;
            return tslib_1.__generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        url = new URL(request.url);
                        shopParam = url.searchParams.get('shop');
                        if (request.method === 'GET' && !shopParam) {
                            return [2 /*return*/, {}];
                        }
                        _a = shopParam;
                        if (_a) return [3 /*break*/, 2];
                        return [4 /*yield*/, request.formData()];
                    case 1:
                        _a = (_b.sent()).get('shop');
                        _b.label = 2;
                    case 2:
                        shop = _a;
                        if (!shop) {
                            logger.debug('Missing shop parameter', { shop: shop });
                            return [2 /*return*/, { shop: types_1.LoginErrorType.MissingShop }];
                        }
                        shopWithoutProtocol = shop.replace(/^https?:\/\//, '');
                        shopWithDomain = (shop === null || shop === void 0 ? void 0 : shop.indexOf('.')) === -1
                            ? "".concat(shopWithoutProtocol, ".myshopify.com")
                            : shopWithoutProtocol;
                        sanitizedShop = api.utils.sanitizeShop(shopWithDomain);
                        if (!sanitizedShop) {
                            logger.debug('Invalid shop parameter', { shop: shop });
                            return [2 /*return*/, { shop: types_1.LoginErrorType.InvalidShop }];
                        }
                        redirectUrl = "".concat(config.appUrl).concat(config.auth.path, "?shop=").concat(sanitizedShop);
                        logger.info("Redirecting login request to ".concat(redirectUrl), {
                            shop: sanitizedShop,
                        });
                        throw (0, server_runtime_1.redirect)(redirectUrl);
                }
            });
        });
    };
}
exports.loginFactory = loginFactory;
//# sourceMappingURL=login.js.map