"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAppBridgeHeaders = exports.redirectWithAppBridgeHeaders = void 0;
var const_1 = require("../const");
function redirectWithAppBridgeHeaders(params, shop) {
    var config = params.config;
    var redirectUri = "".concat(config.appUrl).concat(config.auth.path, "?shop=").concat(shop);
    throw new Response(undefined, {
        status: 401,
        statusText: 'Unauthorized',
        headers: getAppBridgeHeaders(redirectUri),
    });
}
exports.redirectWithAppBridgeHeaders = redirectWithAppBridgeHeaders;
function getAppBridgeHeaders(url) {
    var _a;
    return new Headers((_a = {}, _a[const_1.REAUTH_URL_HEADER] = url, _a));
}
exports.getAppBridgeHeaders = getAppBridgeHeaders;
//# sourceMappingURL=redirect-with-app-bridge-headers.js.map