"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.redirectToAuthPage = void 0;
var tslib_1 = require("tslib");
var begin_auth_1 = require("./begin-auth");
var redirect_with_exitiframe_1 = require("./redirect-with-exitiframe");
var redirect_with_app_bridge_headers_1 = require("./redirect-with-app-bridge-headers");
function redirectToAuthPage(params, request, shop, isOnline) {
    if (isOnline === void 0) { isOnline = false; }
    return tslib_1.__awaiter(this, void 0, void 0, function () {
        var url, isEmbeddedRequest, isXhrRequest;
        return tslib_1.__generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    url = new URL(request.url);
                    isEmbeddedRequest = url.searchParams.get('embedded') === '1';
                    isXhrRequest = request.headers.get('authorization');
                    if (!isXhrRequest) return [3 /*break*/, 1];
                    (0, redirect_with_app_bridge_headers_1.redirectWithAppBridgeHeaders)(params, shop);
                    return [3 /*break*/, 4];
                case 1:
                    if (!isEmbeddedRequest) return [3 /*break*/, 2];
                    (0, redirect_with_exitiframe_1.redirectWithExitIframe)(params, request, shop);
                    return [3 /*break*/, 4];
                case 2: return [4 /*yield*/, (0, begin_auth_1.beginAuth)(params, request, isOnline, shop)];
                case 3: throw _a.sent();
                case 4: return [2 /*return*/];
            }
        });
    });
}
exports.redirectToAuthPage = redirectToAuthPage;
//# sourceMappingURL=redirect-to-auth-page.js.map