"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handleClientError = void 0;
var tslib_1 = require("tslib");
var shopify_api_1 = require("@shopify/shopify-api");
var redirect_to_auth_page_1 = require("./redirect-to-auth-page");
function handleClientError(_a) {
    var params = _a.params, request = _a.request, error = _a.error, shop = _a.shop;
    return tslib_1.__awaiter(this, void 0, void 0, function () {
        return tslib_1.__generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    if (!(error instanceof shopify_api_1.HttpResponseError)) return [3 /*break*/, 4];
                    params.logger.debug("Got an HTTP response error from the API: ".concat(error.message), {
                        code: error.response.code,
                        statusText: error.response.statusText,
                        body: JSON.stringify(error.response.body),
                    });
                    if (!(error.response.code === 401)) return [3 /*break*/, 2];
                    return [4 /*yield*/, (0, redirect_to_auth_page_1.redirectToAuthPage)(params, request, shop)];
                case 1: throw _b.sent();
                case 2: 
                // forward a minimal copy of the upstream HTTP response instead of an Error:
                throw new Response(JSON.stringify(error.response.body), {
                    status: error.response.code,
                    headers: {
                        'Content-Type': error.response.headers['Content-Type'],
                    },
                });
                case 3: return [3 /*break*/, 5];
                case 4:
                    params.logger.debug("Got a response error from the API: ".concat(error.message));
                    throw error;
                case 5: return [2 /*return*/];
            }
        });
    });
}
exports.handleClientError = handleClientError;
//# sourceMappingURL=handle-client-error.js.map