"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ensureCORSHeadersFactory = void 0;
var const_1 = require("../const");
function ensureCORSHeadersFactory(params, request) {
    var logger = params.logger, config = params.config;
    return function ensureCORSHeaders(response) {
        var origin = request.headers.get('Origin');
        if (origin && origin !== config.appUrl) {
            logger.debug('Request comes from a different origin, adding CORS headers');
            response.headers.set('Access-Control-Allow-Origin', '*');
            response.headers.set('Access-Control-Allow-Headers', 'Authorization');
            response.headers.set('Access-Control-Expose-Headers', const_1.REAUTH_URL_HEADER);
        }
        return response;
    };
}
exports.ensureCORSHeadersFactory = ensureCORSHeadersFactory;
//# sourceMappingURL=ensure-cors-headers.js.map