import { Shopify, ShopifyRestResources } from '@shopify/shopify-api';
import type { BasicParams } from '../../types';
import type { AppConfig, AppConfigArg } from '../../config-types';
import type { AdminContext } from './types';
export declare class AuthStrategy<Config extends AppConfigArg, Resources extends ShopifyRestResources = ShopifyRestResources> {
    protected api: Shopify;
    protected config: AppConfig;
    protected logger: Shopify['logger'];
    constructor({ api, config, logger }: BasicParams);
    authenticateAdmin(request: Request): Promise<AdminContext<Config, Resources>>;
    private authenticateAndGetSessionContext;
    private handleAuthBeginRequest;
    private handleAuthCallbackRequest;
    private validateUrlParams;
    private ensureInstalledOnShop;
    private testSession;
    private ensureValidShopParam;
    private ensureAppIsEmbeddedIfRequired;
    private ensureSessionTokenSearchParamIfRequired;
    private ensureSessionExists;
    private validateAuthenticatedSession;
    private loadSession;
    private redirectToShopifyOrAppRoot;
    private redirectToBouncePage;
    private renderAppBridge;
    private overriddenRestClient;
    private createBillingContext;
    private createAdminApiContext;
}
//# sourceMappingURL=authenticate.d.ts.map