'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

function registerWebhooksFactory({
  api,
  logger
}) {
  return async function registerWebhooks({
    session
  }) {
    return api.webhooks.register({
      session
    }).then(response => {
      Object.entries(response).forEach(([topic, topicResults]) => {
        topicResults.forEach(({
          success,
          ...rest
        }) => {
          if (success) {
            logger.debug('Registered webhook', {
              topic,
              shop: session.shop,
              operation: rest.operation
            });
          } else {
            logger.error('Failed to register webhook', {
              topic,
              shop: session.shop,
              result: JSON.stringify(rest.result)
            });
          }
        });
      });
      return response;
    });
  };
}

exports.registerWebhooksFactory = registerWebhooksFactory;
