'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var isbot = require('isbot');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var isbot__default = /*#__PURE__*/_interopDefaultLegacy(isbot);

function rejectBotRequest({
  logger
}, request) {
  if (isbot__default["default"](request.headers.get('User-Agent'))) {
    logger.debug('Request is from a bot, skipping auth');
    throw new Response(undefined, {
      status: 410,
      statusText: 'Gone'
    });
  }
}

exports.rejectBotRequest = rejectBotRequest;
