'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var serverRuntime = require('@remix-run/server-runtime');

function redirectWithExitIframe(params, request, shop) {
  const {
    api,
    config
  } = params;
  const url = new URL(request.url);
  const queryParams = url.searchParams;
  const host = api.utils.sanitizeHost(queryParams.get('host'));
  queryParams.set('shop', shop);
  queryParams.set('exitIframe', `${config.auth.path}?shop=${shop}`);
  if (host) {
    queryParams.set('host', host);
  }
  throw serverRuntime.redirect(`${config.auth.exitIframePath}?${queryParams.toString()}`);
}

exports.redirectWithExitIframe = redirectWithExitIframe;
