'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var beginAuth = require('./begin-auth.js');
var redirectWithExitiframe = require('./redirect-with-exitiframe.js');
var redirectWithAppBridgeHeaders = require('./redirect-with-app-bridge-headers.js');

async function redirectToAuthPage(params, request, shop, isOnline = false) {
  const url = new URL(request.url);
  const isEmbeddedRequest = url.searchParams.get('embedded') === '1';
  const isXhrRequest = request.headers.get('authorization');
  if (isXhrRequest) {
    redirectWithAppBridgeHeaders.redirectWithAppBridgeHeaders(params, shop);
  } else if (isEmbeddedRequest) {
    redirectWithExitiframe.redirectWithExitIframe(params, request, shop);
  } else {
    throw await beginAuth.beginAuth(params, request, isOnline, shop);
  }
}

exports.redirectToAuthPage = redirectToAuthPage;
