'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var shopifyApi = require('@shopify/shopify-api');
var redirectToAuthPage = require('./redirect-to-auth-page.js');

async function handleClientError({
  params,
  request,
  error,
  shop
}) {
  if (error instanceof shopifyApi.HttpResponseError) {
    params.logger.debug(`Got an HTTP response error from the API: ${error.message}`, {
      code: error.response.code,
      statusText: error.response.statusText,
      body: JSON.stringify(error.response.body)
    });
    if (error.response.code === 401) {
      throw await redirectToAuthPage.redirectToAuthPage(params, request, shop);
    } else {
      // forward a minimal copy of the upstream HTTP response instead of an Error:
      throw new Response(JSON.stringify(error.response.body), {
        status: error.response.code,
        headers: {
          'Content-Type': error.response.headers['Content-Type']
        }
      });
    }
  } else {
    params.logger.debug(`Got a response error from the API: ${error.message}`);
    throw error;
  }
}

exports.handleClientError = handleClientError;
