'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

function addDocumentResponseHeadersFactory(params) {
  const {
    api,
    config
  } = params;
  return function (request, headers) {
    const {
      searchParams
    } = new URL(request.url);
    const shop = api.utils.sanitizeShop(searchParams.get('shop'));
    addDocumentResponseHeaders(headers, config.isEmbeddedApp, shop);
  };
}
function addDocumentResponseHeaders(headers, isEmbeddedApp, shop) {
  if (shop) {
    headers.set('Link', '<https://cdn.shopify.com/shopifycloud/app-bridge.js>; rel="preload"; as="script";');
  }
  if (isEmbeddedApp) {
    if (shop) {
      headers.set('Content-Security-Policy', `frame-ancestors https://${shop} https://admin.shopify.com https://*.spin.dev;`);
    }
  } else {
    headers.set('Content-Security-Policy', `frame-ancestors 'none';`);
  }
}

exports.addDocumentResponseHeaders = addDocumentResponseHeaders;
exports.addDocumentResponseHeadersFactory = addDocumentResponseHeadersFactory;
