import type { I18nDetails, TranslationDictionary, MaybePromise } from './types';
export interface ConnectionState {
    loading: boolean;
    fallbacks: TranslationDictionary[];
    translations: TranslationDictionary[];
}
type TranslationGetter = (locale: string) => MaybePromise<TranslationDictionary | undefined>;
interface TranslationMap {
    [key: string]: MaybePromise<TranslationDictionary | undefined>;
}
export interface RegisterOptions {
    id: string;
    translations?: TranslationGetter | TranslationMap;
    fallback?: TranslationDictionary;
}
interface TranslationState {
    loading: boolean;
    translations: TranslationDictionary[];
}
export interface Subscriber {
    (translations: TranslationState, details: I18nDetails): void;
}
export interface ConnectionResult {
    resolve(): Promise<void>;
    disconnect(): void;
}
export interface ExtractedTranslations {
    [id: string]: TranslationDictionary | undefined;
}
export declare class I18nManager {
    details: I18nDetails;
    get loading(): boolean;
    private translationGetters;
    private fallbacks;
    private translations;
    private asyncTranslationIds;
    private subscriptions;
    private translationPromises;
    private idsToUpdate;
    private enqueuedUpdate?;
    constructor(details: I18nDetails, initialTranslations?: ExtractedTranslations);
    resolve(): Promise<void>;
    extract(): ExtractedTranslations;
    register({ id, translations, fallback }: RegisterOptions): void;
    state(ids: string[]): {
        loading: boolean;
        translations: TranslationDictionary[];
    };
    subscribe(ids: string[], subscriber: Subscriber): () => void;
    update(details: I18nDetails): void;
    private setTranslations;
    private updateSubscribersForId;
}
export {};
//# sourceMappingURL=manager.d.ts.map