import { UnicodeCharacterSet } from '../constants/index.mjs';
import { memoizedNumberFormatter } from './translate.mjs';

function getCurrencySymbol(locale, options) {
  const currencyStringRaw = formatCurrency(0, locale, options);
  const controlChars = new RegExp(`${UnicodeCharacterSet.DirectionControl}*`, 'gu');
  const currencyString = currencyStringRaw.replace(controlChars, '');
  const matchResult = /\p{Nd}\p{Po}*\p{Nd}*/gu.exec(currencyString);

  if (!matchResult) {
    throw new Error(`Number input in locale ${locale} is currently not supported.`);
  }

  const formattedAmount = matchResult[0];
  const [currencyPrefix, currencySuffix] = currencyString.split(formattedAmount);
  const elements = {
    symbol: currencyPrefix || currencySuffix,
    prefixed: currencyPrefix !== ''
  };
  return elements;
}
function formatCurrency(amount, locale, options) {
  return memoizedNumberFormatter(locale, {
    style: 'currency',
    ...options
  }).format(amount);
}

export { formatCurrency, getCurrencySymbol };
