/**
 * Used to interpolate a string with values from an object.
 * `{key}` will be replaced with `replacements[key]`.
 */
const DEFAULT_FORMAT = /{\s*(\w+)\s*}/g;
/**
 * Similar to Shopify themes' locale files.
 * `{{key}}` will be replaced with `replacements[key]`.
 */

const MUSTACHE_FORMAT = /{{\s*(\w+)\s*}}/g;
/**
 * Similar to Ruby ERB templating system.
 * `<%= key %>` will be replaced with `replacements[key]`.
 */

const ERB_FORMAT = /<%=\s+(\w+)\s+%>/g;

export { DEFAULT_FORMAT, ERB_FORMAT, MUSTACHE_FORMAT };
