import React from 'react';
import hoistStatics from 'hoist-non-react-statics';
import { useI18n } from './hooks.mjs';

function withI18n(i18nOptions) {
  return WrappedComponent => {
    function WithTranslations(props) {
      const [i18n, ShareTranslations] = useI18n(i18nOptions);
      return /*#__PURE__*/React.createElement(ShareTranslations, null, /*#__PURE__*/React.createElement(WrappedComponent, Object.assign({}, props, {
        i18n: i18n
      })));
    }

    const wrappedComponentName = WrappedComponent.displayName || WrappedComponent.name || 'Component';
    WithTranslations.displayName = `withI18n(${wrappedComponentName})`;
    return hoistStatics(WithTranslations, WrappedComponent);
  };
}

export { withI18n };
