'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

/**
 * Used to interpolate a string with values from an object.
 * `{key}` will be replaced with `replacements[key]`.
 */
const DEFAULT_FORMAT = /{\s*(\w+)\s*}/g;
/**
 * Similar to Shopify themes' locale files.
 * `{{key}}` will be replaced with `replacements[key]`.
 */

const MUSTACHE_FORMAT = /{{\s*(\w+)\s*}}/g;
/**
 * Similar to Ruby ERB templating system.
 * `<%= key %>` will be replaced with `replacements[key]`.
 */

const ERB_FORMAT = /<%=\s+(\w+)\s+%>/g;

exports.DEFAULT_FORMAT = DEFAULT_FORMAT;
exports.ERB_FORMAT = ERB_FORMAT;
exports.MUSTACHE_FORMAT = MUSTACHE_FORMAT;
