'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

class MissingTranslationError extends Error {
  constructor(key, locale) {
    super(`Missing translation for key: ${key} in locale: ${locale}`);
  }

}
class MissingReplacementError extends Error {
  constructor(replacement, replacements = {}) {
    let errorMessage = '';
    const replacementKeys = Object.keys(replacements);

    if (replacementKeys.length < 1) {
      errorMessage = `No replacement found for key '${replacement}' (and no replacements were passed in).`;
    } else {
      errorMessage = `No replacement found for key '${replacement}'. The following replacements were passed: ${replacementKeys.map(key => `'${key}'`).join(', ')}`;
    }

    super(errorMessage);
  }

}
class MissingCurrencyCodeError extends Error {
  constructor(additionalMessage = '') {
    const baseErrorMessage = 'No currency code provided.';
    super(additionalMessage === '' ? baseErrorMessage : `${baseErrorMessage} ${additionalMessage}`);
  }

}
class MissingCountryError extends Error {
  constructor(additionalMessage = '') {
    const baseErrorMessage = 'No country code provided.';
    super(additionalMessage === '' ? baseErrorMessage : `${baseErrorMessage} ${additionalMessage}`);
  }

}

exports.MissingCountryError = MissingCountryError;
exports.MissingCurrencyCodeError = MissingCurrencyCodeError;
exports.MissingReplacementError = MissingReplacementError;
exports.MissingTranslationError = MissingTranslationError;
