'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var hoistStatics = require('hoist-non-react-statics');
var hooks = require('./hooks.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);
var hoistStatics__default = /*#__PURE__*/_interopDefaultLegacy(hoistStatics);

function withI18n(i18nOptions) {
  return WrappedComponent => {
    function WithTranslations(props) {
      const [i18n, ShareTranslations] = hooks.useI18n(i18nOptions);
      return /*#__PURE__*/React__default["default"].createElement(ShareTranslations, null, /*#__PURE__*/React__default["default"].createElement(WrappedComponent, Object.assign({}, props, {
        i18n: i18n
      })));
    }

    const wrappedComponentName = WrappedComponent.displayName || WrappedComponent.name || 'Component';
    WithTranslations.displayName = `withI18n(${wrappedComponentName})`;
    return hoistStatics__default["default"](WithTranslations, WrappedComponent);
  };
}

exports.withI18n = withI18n;
