'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var child_process = require('child_process');
var path = require('path');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var path__default = /*#__PURE__*/_interopDefaultLegacy(path);

const TRANSLATION_DIRECTORY_NAME = 'translations';
const DEFAULT_FALLBACK_LOCALE = 'en';
function getLocaleIds(options) {
  const {
    translationFilePaths,
    fallbackLocale = DEFAULT_FALLBACK_LOCALE
  } = options;
  return translationFilePaths.map(filePath => path__default["default"].basename(filePath, path__default["default"].extname(filePath))).filter(locale => locale !== fallbackLocale).sort();
}
function toArrayString(stringArray) {
  return `[${stringArray.map(singleStr => JSON.stringify(singleStr)).join(', ')}]`;
}
function findTranslationBuckets(rootDir) {
  // `find` is used here instead of Node's glob because it performs much faster
  // (20s vs 1s in web with ~750 translation folders and 21 langs)
  const files = child_process.execSync(`find ${rootDir} -type d \\( -path ${rootDir}/node_modules -o -path ${rootDir}/build -o -path ${rootDir}/tmp -o -path ${rootDir}/.git -o -path ${rootDir}/public \\) -prune -o -name '*.json' -print | grep /${TRANSLATION_DIRECTORY_NAME}/`, {
    maxBuffer: 2000000 * 10
  }).toString().trim().split('\n').sort();
  return files.reduce((acc, translationPath) => {
    const translationsDir = path__default["default"].dirname(translationPath);

    if (!acc[translationsDir]) {
      acc[translationsDir] = [];
    }

    acc[translationsDir].push(translationPath);
    return acc;
  }, {});
}

exports.DEFAULT_FALLBACK_LOCALE = DEFAULT_FALLBACK_LOCALE;
exports.TRANSLATION_DIRECTORY_NAME = TRANSLATION_DIRECTORY_NAME;
exports.findTranslationBuckets = findTranslationBuckets;
exports.getLocaleIds = getLocaleIds;
exports.toArrayString = toArrayString;
