'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var path = require('path');
var fs = require('fs-extra');
var shared = require('./shared.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var fs__default = /*#__PURE__*/_interopDefaultLegacy(fs);

function generateTranslationIndexes() {
  const fallbackLocale = shared.DEFAULT_FALLBACK_LOCALE;
  const translationBuckets = shared.findTranslationBuckets(process.cwd());
  Object.entries(translationBuckets).forEach(([translationsDir, translationFilePaths]) => {
    const localeIdArrayString = shared.toArrayString(shared.getLocaleIds({
      translationFilePaths,
      fallbackLocale
    }));
    fs__default["default"].writeFile(path.join(translationsDir, 'index.js'), `/* This is generated and should not be checked-in*/\nexport default ${localeIdArrayString};`);
  });
}

exports.generateTranslationIndexes = generateTranslationIndexes;
