'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var shared = require('./shared.js');

function fallbackTranslationsImport(template, {
  id,
  fallbackLocale
}) {
  return template(`import ${id} from './${shared.TRANSLATION_DIRECTORY_NAME}/${fallbackLocale}.json';`, {
    sourceType: 'module'
  })();
}
function translationsImport(template, {
  id
}) {
  return template(`import ${id} from './${shared.TRANSLATION_DIRECTORY_NAME}';`, {
    sourceType: 'module'
  })();
}
function i18nCallExpression(template, {
  id,
  fallbackID,
  translationArrayID,
  bindingName,
  translationFilePaths,
  fallbackLocale,
  withExplicitPaths
}) {
  const localeIds = shared.getLocaleIds({
    translationFilePaths,
    fallbackLocale
  });
  const dictionaryRetriever = withExplicitPaths ? buildExplicitImports(id, localeIds) : `${generateLocaleReturnCheck(localeIds, translationArrayID)}
      return ${generateImportDefinition(id)}${generateThenChain(generateReturnDefaultFunction())};`;
  return template(`${bindingName}({
        id: '${id}',
        fallback: ${fallbackID},
        translations(locale) {
          ${dictionaryRetriever}
        },
      })`, {
    sourceType: 'module',
    plugins: ['dynamicImport'],
    preserveComments: true
  })();
}
function i18nGeneratedDictionaryCallExpression(template, {
  id,
  translationsID,
  bindingName
}) {
  return template(`${bindingName}({
        id: '${id}',
        fallback: Object.values(${translationsID})[0],
        translations(locale) {
          return Promise.resolve(${translationsID}[locale]);
        },
      })`, {
    sourceType: 'module',
    plugins: ['dynamicImport'],
    preserveComments: true
  })();
}

function buildExplicitImports(bindingId, localeIds) {
  if (localeIds.length === 0) {
    return `return;`;
  }

  if (localeIds.length === 1) {
    const localeId = localeIds[0];
    return `if (locale !== "${localeId}") {
      return;
    }

    return ${generateImportDefinition(bindingId, localeId)}${generateThenChain(generateReturnDefaultFunction())};`;
  }

  const returnDefaultVariable = 'returnDefault';

  const generateReturnStatement = id => {
    return `return ${generateImportDefinition(bindingId, id)}${generateThenChain(returnDefaultVariable)};`;
  };

  const switchStatementInternals = localeIds.reduce((merged, value) => {
    return merged.concat(`case "${value}":
      ${generateReturnStatement(value)}
    `);
  }, '');
  const localeSelectionStatement = `switch (locale) {
    ${switchStatementInternals}
  }`;
  return `const ${returnDefaultVariable} = ${generateReturnDefaultFunction()};
  ${localeSelectionStatement}`;
}

function generateImportDefinition(bindingId, explicitFileName) {
  if (explicitFileName) {
    return `import(/* webpackChunkName: "${bindingId}-i18n" */ "./${shared.TRANSLATION_DIRECTORY_NAME}/${explicitFileName}.json")`;
  }

  return `import(/* webpackChunkName: "${bindingId}-i18n", webpackMode: "lazy-once" */ \`./${shared.TRANSLATION_DIRECTORY_NAME}/\${locale}.json\`)`;
}

function generateLocaleReturnCheck(localeIds, translationArrayID) {
  const translationArrayString = translationArrayID ? translationArrayID : shared.toArrayString(localeIds);
  return `if (${translationArrayString}.indexOf(locale) < 0) {
    return;
  }`;
}

function generateReturnDefaultFunction() {
  return '(dict) => dict && dict.default';
}

function generateThenChain(thenFunc) {
  return `.then(${thenFunc})`;
}

exports.fallbackTranslationsImport = fallbackTranslationsImport;
exports.i18nCallExpression = i18nCallExpression;
exports.i18nGeneratedDictionaryCallExpression = i18nGeneratedDictionaryCallExpression;
exports.translationsImport = translationsImport;
