import { useRef, useEffect } from 'react';
import { useIsomorphicLayoutEffect } from './isomorphic-layout-effect.mjs';

function useTimeout(callback, delay) {
  const savedCallback = useRef(callback); // Need to use a layout effect to force the saved callback to be synchronously updated during a commit

  useIsomorphicLayoutEffect(() => {
    savedCallback.current = callback;
  }, [callback]);
  useEffect(() => {
    function tick() {
      savedCallback.current();
    }

    if (delay !== null) {
      const id = setTimeout(tick, delay);
      return () => clearTimeout(id);
    }

    return undefined;
  }, [delay]);
}

export { useTimeout };
